/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller;

import de.p2tools.p2lib.configfile.ConfigFile;
import de.p2tools.p2lib.configfile.ConfigWriteFile;
import de.p2tools.p2lib.guitools.P2GuiSize;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.log.P2LogMessage;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.config.ProgInfosFactory;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import de.p2tools.p2podder.controller.data.episode.EpisodeFactory;
import java.nio.file.Path;
import javafx.application.Platform;

public class ProgQuitFactory {
    private ProgQuitFactory() {
    }

    public static void quit() {
        ProgQuitFactory.stopAll();
        ProgQuitFactory.writeTabSettings();
        if (ProgData.getInstance().primaryStageBig.isShowing()) {
            P2GuiSize.getSize(ProgConfig.SYSTEM_SIZE_GUI, ProgData.getInstance().primaryStageBig);
        }
        if (ProgData.getInstance().primaryStageSmall != null && ProgData.getInstance().primaryStageSmall.isShowing()) {
            P2GuiSize.getSize(ProgConfig.SMALL_PODDER_SIZE, ProgData.getInstance().primaryStageSmall);
        }
        ProgQuitFactory.saveProgConfig();
        P2LogMessage.endMsg();
        Platform.runLater(() -> {
            Platform.exit();
            System.exit(0);
        });
    }

    public static void saveAll() {
        P2Log.sysLog("save all data");
        ProgQuitFactory.saveProgConfig();
    }

    private static void saveProgConfig() {
        P2Log.sysLog("Alle Programmeinstellungen sichern");
        Path xmlFilePath = ProgInfosFactory.getSettingsFile();
        ConfigFile configFile = new ConfigFile(xmlFilePath.toString(), true);
        ProgConfig.addConfigData(configFile);
        ConfigWriteFile.writeConfigFile(configFile);
    }

    private static void stopAll() {
        EpisodeFactory.stopAllEpisode();
        ProgData.getInstance().downloadList.removeIf(DownloadData::isStateFinished);
        ProgData.getInstance().downloadList.forEach(download -> {
            download.stopDownload();
            download.setStateInit();
        });
    }

    private static void writeTabSettings() {
        ProgData.getInstance().podcastGui.getPodcastGuiController().saveTable();
        ProgData.getInstance().downloadGui.getDownloadGuiController().saveTable();
        ProgData.getInstance().episodeGui.getEpisodeGuiController().saveTable();
    }
}

