/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder;

import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.P2PodderFactory;
import de.p2tools.p2podder.ProgMenu;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.gui.DownloadGui;
import de.p2tools.p2podder.gui.EpisodeGui;
import de.p2tools.p2podder.gui.PodcastGui;
import de.p2tools.p2podder.gui.StatusBarController;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;

public class P2PodderController
extends BorderPane {
    private final Button btnSmallGui = new Button("");
    private final Button btnEpisodes = new Button("Episoden");
    private final Button btnPodcasts = new Button("Podcasts");
    private final Button btnDownloads = new Button("Downloads");
    private final StackPane stackPaneCont = new StackPane();
    private StatusBarController statusBarController;
    private Pane paneEpisodeGui;
    private Pane panePodcastGui;
    private Pane paneDownloadGui;
    private final ProgData progData;
    private final PodcastGui podcastGui = new PodcastGui();
    private final DownloadGui downloadGui = new DownloadGui();
    private final EpisodeGui episodeGui = new EpisodeGui();

    public P2PodderController() {
        this.progData = ProgData.getInstance();
        this.init();
    }

    private void init() {
        try {
            HBox hBoxTop = new HBox();
            hBoxTop.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            hBoxTop.setSpacing(20.0);
            hBoxTop.setAlignment(Pos.CENTER);
            TilePane tilePaneStationFavourite = new TilePane();
            tilePaneStationFavourite.setHgap(25.0);
            tilePaneStationFavourite.setAlignment(Pos.CENTER);
            tilePaneStationFavourite.getChildren().addAll((Node[])new Node[]{this.btnEpisodes, this.btnPodcasts, this.btnDownloads});
            HBox.setHgrow(tilePaneStationFavourite, Priority.ALWAYS);
            hBoxTop.getChildren().addAll((Node[])new Node[]{this.btnSmallGui, tilePaneStationFavourite, new ProgMenu()});
            this.paneEpisodeGui = this.episodeGui.pack();
            this.panePodcastGui = this.podcastGui.pack();
            this.paneDownloadGui = this.downloadGui.pack();
            this.stackPaneCont.getChildren().addAll((Node[])new Node[]{this.paneEpisodeGui, this.panePodcastGui, this.paneDownloadGui});
            this.statusBarController = new StatusBarController(this.progData);
            this.setTop(hBoxTop);
            this.setCenter(this.stackPaneCont);
            this.setBottom(this.statusBarController);
            this.setPadding(new Insets(0.0));
            this.initButton();
            this.initPanel();
        }
        catch (Exception ex) {
            P2Log.errorLog(597841023, ex);
        }
    }

    public void initPanel() {
        if (ProgData.auto) {
            this.initPanelDownload();
        } else {
            switch (ProgConfig.SYSTEM_LAST_TAB.get()) {
                default: {
                    this.initPanelEpisode();
                    break;
                }
                case 1: {
                    this.initPanelPodcast();
                    break;
                }
                case 2: {
                    this.initPanelDownload();
                }
            }
        }
    }

    private void initButton() {
        this.btnSmallGui.setTooltip(new Tooltip("kleine \u00dcbersicht der Episoden anzeigen"));
        this.btnSmallGui.setOnAction(e -> P2PodderFactory.selPanelSmallPodder());
        this.btnSmallGui.setMaxWidth(Double.MAX_VALUE);
        this.btnSmallGui.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-2"});
        this.btnSmallGui.setGraphic(ProgIcons.ICON_MENU_SMALL_PODDER_24.getImageView());
        this.btnEpisodes.setTooltip(new Tooltip("Episoden anzeigen"));
        this.btnEpisodes.setOnAction(e -> this.selPanelEpisode());
        this.btnEpisodes.setMaxWidth(Double.MAX_VALUE);
        this.btnPodcasts.setTooltip(new Tooltip("Podcasts anzeigen"));
        this.btnPodcasts.setOnAction(e -> this.selPanelPodcast());
        this.btnPodcasts.setMaxWidth(Double.MAX_VALUE);
        this.btnDownloads.setTooltip(new Tooltip("Downloads anzeigen"));
        this.btnDownloads.setOnAction(e -> this.selPanelDownload());
        this.btnDownloads.setMaxWidth(Double.MAX_VALUE);
        this.btnEpisodes.setOnMouseClicked(mouseEvent -> {
            if (!((Node)this.stackPaneCont.getChildren().get(this.stackPaneCont.getChildren().size() - 1)).equals(this.paneEpisodeGui)) {
                return;
            }
            if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                ProgConfig.EPISODE__INFO_IS_SHOWING.setValue(!ProgConfig.EPISODE__INFO_IS_SHOWING.get());
            }
        });
        this.btnPodcasts.setOnMouseClicked(mouseEvent -> {
            if (!((Node)this.stackPaneCont.getChildren().get(this.stackPaneCont.getChildren().size() - 1)).equals(this.panePodcastGui)) {
                return;
            }
            if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                ProgConfig.PODCAST__INFO_IS_SHOWING.setValue(!ProgConfig.PODCAST__INFO_IS_SHOWING.get());
            }
        });
        this.btnDownloads.setOnMouseClicked(mouseEvent -> {
            if (!((Node)this.stackPaneCont.getChildren().get(this.stackPaneCont.getChildren().size() - 1)).equals(this.paneDownloadGui)) {
                return;
            }
            if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                ProgConfig.DOWNLOAD__INFO_IS_SHOWING.setValue(!ProgConfig.DOWNLOAD__INFO_IS_SHOWING.get());
            }
        });
    }

    private void selPanelEpisode() {
        ProgConfig.SYSTEM_LAST_TAB.set(0);
        if (((Node)this.stackPaneCont.getChildren().get(this.stackPaneCont.getChildren().size() - 1)).equals(this.paneEpisodeGui)) {
            if (!ProgConfig.EPISODE__FILTER_IS_RIP.get()) {
                ProgConfig.EPISODE__FILTER_IS_SHOWING.setValue(!ProgConfig.EPISODE__FILTER_IS_SHOWING.get());
            }
            return;
        }
        this.initPanelEpisode();
    }

    private void initPanelEpisode() {
        ProgData.PODCAST_TAB_ON.setValue(Boolean.FALSE);
        ProgData.EPISODE_TAB_ON.setValue(Boolean.TRUE);
        ProgData.DOWNLOAD_TAB_ON.setValue(Boolean.FALSE);
        this.setButtonStyle(this.btnEpisodes);
        this.paneEpisodeGui.toFront();
        this.progData.episodeGui.getEpisodeGuiController().isShown();
        this.statusBarController.setStatusbarIndex(StatusBarController.StatusbarIndex.EPISODE);
    }

    private void selPanelPodcast() {
        ProgConfig.SYSTEM_LAST_TAB.set(1);
        if (((Node)this.stackPaneCont.getChildren().get(this.stackPaneCont.getChildren().size() - 1)).equals(this.panePodcastGui)) {
            if (!ProgConfig.PODCAST__FILTER_IS_RIP.get()) {
                ProgConfig.PODCAST__FILTER_IS_SHOWING.setValue(!ProgConfig.PODCAST__FILTER_IS_SHOWING.get());
            }
            return;
        }
        this.initPanelPodcast();
    }

    private void initPanelPodcast() {
        ProgData.PODCAST_TAB_ON.setValue(Boolean.TRUE);
        ProgData.EPISODE_TAB_ON.setValue(Boolean.FALSE);
        ProgData.DOWNLOAD_TAB_ON.setValue(Boolean.FALSE);
        this.setButtonStyle(this.btnPodcasts);
        this.panePodcastGui.toFront();
        this.progData.podcastGui.getPodcastGuiController().isShown();
        this.statusBarController.setStatusbarIndex(StatusBarController.StatusbarIndex.PODCAST);
    }

    private void selPanelDownload() {
        ProgConfig.SYSTEM_LAST_TAB.set(2);
        if (((Node)this.stackPaneCont.getChildren().get(this.stackPaneCont.getChildren().size() - 1)).equals(this.paneDownloadGui)) {
            if (!ProgConfig.DOWNLOAD__FILTER_IS_RIP.get()) {
                ProgConfig.DOWNLOAD__FILTER_IS_SHOWING.setValue(!ProgConfig.DOWNLOAD__FILTER_IS_SHOWING.get());
            }
            return;
        }
        this.initPanelDownload();
    }

    private void initPanelDownload() {
        ProgData.PODCAST_TAB_ON.setValue(Boolean.FALSE);
        ProgData.EPISODE_TAB_ON.setValue(Boolean.FALSE);
        ProgData.DOWNLOAD_TAB_ON.setValue(Boolean.TRUE);
        this.setButtonStyle(this.btnDownloads);
        this.paneDownloadGui.toFront();
        this.progData.downloadGui.getDownloadGuiController().isShown();
        this.statusBarController.setStatusbarIndex(StatusBarController.StatusbarIndex.DOWNLOAD);
    }

    private void setButtonStyle(Button btnSel) {
        this.btnEpisodes.getStyleClass().clear();
        this.btnPodcasts.getStyleClass().clear();
        this.btnDownloads.getStyleClass().clear();
        if (btnSel.equals(this.btnEpisodes)) {
            this.btnEpisodes.getStyleClass().add("btnTabTop-sel");
        } else {
            this.btnEpisodes.getStyleClass().add("btnTabTop");
        }
        if (btnSel.equals(this.btnPodcasts)) {
            this.btnPodcasts.getStyleClass().add("btnTabTop-sel");
        } else {
            this.btnPodcasts.getStyleClass().add("btnTabTop");
        }
        if (btnSel.equals(this.btnDownloads)) {
            this.btnDownloads.getStyleClass().add("btnTabTop-sel");
        } else {
            this.btnDownloads.getStyleClass().add("btnTabTop");
        }
    }
}

