/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder;

import de.p2tools.p2lib.P2LibInit;
import de.p2tools.p2lib.guitools.P2GuiSize;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2podder.P2PodderController;
import de.p2tools.p2podder.controller.ProgQuitFactory;
import de.p2tools.p2podder.controller.ProgStartAfterGui;
import de.p2tools.p2podder.controller.ProgStartBeforeGui;
import de.p2tools.p2podder.controller.config.PShortCutFactory;
import de.p2tools.p2podder.controller.config.ProgColorList;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.gui.dialog.EpisodeInfoDialogController;
import de.p2tools.p2podder.gui.smallgui.SmallGuiPack;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class P2Podder
extends Application {
    private static final String LOG_TEXT_PROGRAM_START = "Dauer Programmstart";
    protected ProgData progData;

    public static void main(String[] args2) {
        P2Podder.launch(args2);
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void start(Stage primaryStage) {
        P2Duration.counterStart(LOG_TEXT_PROGRAM_START);
        this.progData = ProgData.getInstance();
        this.progData.primaryStage = primaryStage;
        this.progData.primaryStageBig = primaryStage;
        ProgStartBeforeGui.workBeforeGui();
        this.initRootLayout();
        ProgStartAfterGui.workAfterGui();
        P2Duration.onlyPing("Gui steht!");
        P2Duration.counterStop(LOG_TEXT_PROGRAM_START);
    }

    private void initRootLayout() {
        try {
            this.progData.episodeInfoDialogController = new EpisodeInfoDialogController(this.progData);
            this.progData.p2PodderController = new P2PodderController();
            Scene sceneBig = new Scene(this.progData.p2PodderController, P2GuiSize.getSceneSize(ProgConfig.SYSTEM_SIZE_GUI, true), P2GuiSize.getSceneSize(ProgConfig.SYSTEM_SIZE_GUI, false));
            this.progData.primaryStageBig.setScene(sceneBig);
            this.progData.primaryStageBig.setOnCloseRequest(e -> {
                e.consume();
                ProgQuitFactory.quit();
            });
            if (ProgData.auto) {
                ProgConfig.SYSTEM_SMALL_PODDER.set(false);
            }
            this.progData.primaryStageBig.setOnShowing(e -> P2GuiSize.setSizePos(ProgConfig.SYSTEM_SIZE_GUI, this.progData.primaryStageBig));
            this.progData.primaryStageBig.setOnShown(e -> P2GuiSize.setSizePos(ProgConfig.SYSTEM_SIZE_GUI, this.progData.primaryStageBig));
            ProgConfig.SYSTEM_DARK_THEME.addListener((u, o, n) -> ProgColorList.setColorTheme());
            ProgConfig.SYSTEM_SMALL_PODDER.addListener((u, o, n) -> this.selectGui());
            PShortCutFactory.addShortCut(this.progData.primaryStageBig.getScene());
            P2LibInit.addP2CssToScene(sceneBig);
            this.selectGui();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void selectGui() {
        if (!ProgData.auto && ProgConfig.SYSTEM_SMALL_PODDER.getValue().booleanValue()) {
            this.progData.smallGuiPack = new SmallGuiPack();
            this.progData.primaryStage = this.progData.primaryStageSmall = ProgData.getInstance().smallGuiPack.getStage();
            P2LibInit.setActStage(this.progData.primaryStageSmall);
            PShortCutFactory.addShortCut(this.progData.primaryStageSmall.getScene());
            ProgData.EPISODE_TAB_ON.setValue(Boolean.FALSE);
            ProgData.PODCAST_TAB_ON.setValue(Boolean.FALSE);
            ProgData.DOWNLOAD_TAB_ON.setValue(Boolean.FALSE);
            if (ProgData.getInstance().primaryStageBig.isShowing()) {
                P2GuiSize.getSize(ProgConfig.SYSTEM_SIZE_GUI, this.progData.primaryStageBig);
            }
            this.progData.primaryStageBig.close();
            this.progData.primaryStageSmall.show();
        } else {
            this.progData.primaryStage = this.progData.primaryStageBig;
            P2LibInit.setActStage(this.progData.primaryStageBig);
            this.progData.p2PodderController.initPanel();
            this.progData.primaryStageBig.show();
        }
        if (ProgData.firstProgramStart) {
            ProgConfig.SYSTEM_DARK_THEME.set(ProgConfig.SYSTEM_DARK_THEME_START.get());
            ProgConfig.SYSTEM_BLACK_WHITE_ICON.set(ProgConfig.SYSTEM_BLACK_WHITE_ICON_START.get());
        }
    }
}

