/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder;

import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.log.P2LogMessage;
import de.p2tools.p2podder.controller.config.ProgData;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

public class AppParameter {
    public static final String TEXT_LINE = "===========================================";
    private static final String ARGUMENT_PREFIX = "-";

    void processArgs(String ... arguments) {
        if (arguments == null) {
            return;
        }
        this.printArguments(arguments);
        this.readPathFromArguments(arguments);
        try {
            Options allowed = new Options();
            for (ProgParameter parameter : ProgParameter.values()) {
                allowed.addOption(parameter.shortname, parameter.name, parameter.hasArgs, parameter.helpText);
            }
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(allowed, arguments);
            if (AppParameter.hasOption(line, ProgParameter.HELP)) {
                AppParameter.printHelp(allowed);
                System.exit(0);
            }
            if (AppParameter.hasOption(line, ProgParameter.VERSION)) {
                EventQueue.invokeLater(() -> {
                    P2LogMessage.startMsg("P2Podder", null);
                    P2LogMessage.endMsg();
                    System.exit(0);
                });
            }
            if (AppParameter.hasOption(line, ProgParameter.DEBUG)) {
                ProgData.debug = true;
            }
            if (AppParameter.hasOption(line, ProgParameter.DURATION)) {
                ProgData.duration = true;
            }
            if (AppParameter.hasOption(line, ProgParameter.PATH)) {
                String path = line.getOptionValue(ProgParameter.PATH.name);
                this.setConfigDir(path);
            }
            if (AppParameter.hasOption(line, ProgParameter.AUTO)) {
                ProgData.auto = true;
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(941237890, ex);
        }
    }

    private void readPathFromArguments(String[] arguments) {
        if (arguments == null || arguments.length == 0 || arguments[0].startsWith(ARGUMENT_PREFIX)) {
            return;
        }
        this.setConfigDir(arguments[0]);
    }

    private void setConfigDir(String path) {
        if (!((String)path).endsWith(File.separator)) {
            path = (String)path + File.separator;
        }
        ProgData.configDir = path;
    }

    private void printArguments(String[] aArguments) {
        if (aArguments.length == 0) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(TEXT_LINE);
        for (String argument : aArguments) {
            list.add(String.format("Startparameter: %s", argument));
        }
        list.add(TEXT_LINE);
        P2Log.emptyLine();
        P2Log.sysLog(list);
        P2Log.emptyLine();
    }

    private static boolean hasOption(CommandLine line, ProgParameter parameter) {
        return line.hasOption(parameter.name);
    }

    private static int extractInt(CommandLine line, ProgParameter parameter) {
        return Integer.parseInt(line.getOptionValue(parameter.name));
    }

    private static void printHelp(Options allowed) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("P2Podder", allowed);
    }

    static enum ProgParameter {
        HELP("h", "help", false, "show help"),
        VERSION("v", "version", false, "show version"),
        PATH("p", "path", true, "path of configuration file"),
        AUTO("a", "auto", false, "auto mode"),
        DEBUG("d", "debug", false, "show debug info"),
        DURATION("t", "time", false, "show timekeeping info");

        final String shortname;
        final String name;
        final boolean hasArgs;
        final String helpText;

        private ProgParameter(String shortname, String name, boolean hasArgs, String helpText) {
            this.shortname = shortname;
            this.name = name;
            this.hasArgs = hasArgs;
            this.helpText = helpText;
        }
    }
}

