/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools.log;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.tools.P2InfoFactory;
import de.p2tools.p2lib.tools.P2StringUtils;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.log.P2Logo;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;

public class P2LogMessage {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss").withZone(ZoneId.systemDefault());

    public static void startMsg(String progName, ArrayList<String> addInfo) {
        String[] java;
        ArrayList<String> list = new ArrayList<String>(25);
        list.add("############################################################");
        list.add("");
        list.addAll(P2Logo.LOGO_LIST);
        list.add("");
        list.add("============================================================");
        list.add("");
        list.add("Programmstart: " + formatter.format(P2Log.START_TIME));
        list.add("");
        list.add("============================================================");
        list.add("");
        long totalMem = Runtime.getRuntime().totalMemory();
        list.add("totalMemory: " + totalMem / 1000000L + " MB");
        long maxMem = Runtime.getRuntime().maxMemory();
        list.add("maxMemory: " + maxMem / 1000000L + " MB");
        long freeMem = Runtime.getRuntime().freeMemory();
        list.add("freeMemory: " + freeMem / 1000000L + " MB");
        list.add("");
        list.add("============================================================");
        list.add("");
        list.add(progName + P2InfoFactory.getProgVersionString());
        String compile = P2InfoFactory.getBuildDate();
        if (!compile.isEmpty()) {
            list.add("Compiled: " + compile);
        }
        if (P2LibConst.debug) {
            list.add("-->  DEBUG  <--");
        }
        list.add("");
        list.add("============================================================");
        list.add("");
        list.add("Betriebssystem: " + System.getProperty("os.name"));
        list.add("Bs-Version:     " + System.getProperty("os.version"));
        list.add("Bs-Architektur: " + System.getProperty("os.arch"));
        list.add("");
        list.add("============================================================");
        list.add("");
        list.add("Java");
        for (String ja : java = P2InfoFactory.getJavaVersion()) {
            list.add(ja);
        }
        list.add("");
        list.add("============================================================");
        list.add("");
        if (addInfo != null && !addInfo.isEmpty()) {
            list.addAll(addInfo);
        }
        list.add("");
        list.add("############################################################");
        P2StringUtils.appendString(list, "#  ", "#");
        P2Log.sysLog("");
        P2Log.sysLog(list);
        P2Log.sysLog("");
    }

    public static void endMsg() {
        ArrayList<String> list = new ArrayList<String>(25);
        list.add("############################################################");
        list.add("");
        list.add("Programm beendet");
        list.add("=================");
        Duration duration = Duration.between(P2Log.START_TIME, Instant.now());
        int minute = (int)duration.getSeconds() / 60;
        list.add("");
        list.add("============================================================");
        list.add("  --> Beginn: " + formatter.format(P2Log.START_TIME));
        list.add("  --> Fertig: " + formatter.format(Instant.now()));
        list.add("  --> Dauer[min]: " + String.valueOf(minute == 0 ? "<1" : Integer.valueOf(minute)));
        list.add("============================================================");
        list.add("");
        list.add("");
        list.add("");
        list.add("============================================================");
        list.addAll(P2LogMessage.printErrorMsg());
        list.add("============================================================");
        list.add("");
        list.add("");
        list.add("");
        list.add("============================================================");
        list.addAll(P2Duration.getCounter());
        list.add("============================================================");
        list.add("");
        list.add("");
        list.add("und Tschuess");
        list.add("");
        list.add("############################################################");
        P2StringUtils.appendString(list, "#  ", "#");
        P2Log.sysLog("");
        P2Log.sysLog(list);
        P2Log.sysLog("");
    }

    public static synchronized ArrayList<String> printErrorMsg() {
        int max = 0;
        ArrayList<String> list = new ArrayList<String>();
        if (P2Log.errorList.isEmpty()) {
            list.add("Keine Fehler :)");
            return list;
        }
        list.add("Fehler:");
        list.add("===========");
        for (P2Log.Error e : P2Log.errorList) {
            if (e.callClass.length() <= max) continue;
            max = e.callClass.length();
        }
        ++max;
        for (P2Log.Error e : P2Log.errorList) {
            while (e.callClass.length() < max) {
                e.callClass = e.callClass + " ";
            }
        }
        for (int i = 1; i < P2Log.errorList.size(); ++i) {
            int i_2;
            int i_1;
            for (int k = i; k > 0 && (i_1 = P2Log.errorList.get((int)(k - 1)).errorNr) < (i_2 = P2Log.errorList.get((int)k).errorNr); --k) {
                P2Log.errorList.add(k - 1, P2Log.errorList.remove(k));
            }
        }
        for (P2Log.Error e : P2Log.errorList) {
            String strEx = e.ex ? "  Ex! " : "      ";
            list.add(strEx + e.callClass + " Fehlernummer: " + e.errorNr + " Anzahl: " + e.count);
        }
        return list;
    }
}

