/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools.log;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.tools.P2StringUtils;
import de.p2tools.p2lib.tools.log.P2Logger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class P2Log {
    public static int COUNT = 0;
    public static final String LILNE1 = "############################################################";
    public static final String LILNE2 = "============================================================";
    public static final String LILNE3 = "------------------------------------------------------------";
    public static final String LILNE_EMPTY = "  ";
    public static final Instant START_TIME = Instant.now();
    static final long TO_MEGABYTE = 1000000L;
    static final LinkedList<Error> errorList = new LinkedList();
    static boolean progress = false;

    public static synchronized void extToolLog(String text) {
        P2Logger.LogExtToolMsg(text);
        P2Log.resetProgress();
    }

    public static synchronized void durationLog(ArrayList<String> list) {
        String log = P2StringUtils.appendList(list, P2LibConst.LINE_SEPARATOR);
        if (log.isEmpty()) {
            return;
        }
        if (P2LibConst.duration) {
            P2Logger.LogDuration(log);
        }
    }

    public static synchronized void emptyLine() {
        P2Logger.LogInfo("");
    }

    public static synchronized void progress(String text) {
        progress = true;
        if (!text.isEmpty()) {
            System.out.print(text + "\r");
        }
    }

    public static synchronized void errorLog(int errorNumber, Exception ex) {
        P2Logger.LogSevere(P2Log.addErrNr(errorNumber, ""), ex);
        P2Log.error(errorNumber, ex, new String[0]);
    }

    public static synchronized void errorLog(int errorNumber, String text) {
        P2Logger.LogSevere(P2Log.addErrNr(errorNumber, text));
        P2Log.error(errorNumber, null, new String[]{text});
    }

    public static synchronized void errorLog(int errorNumber, String[] text) {
        Object log = P2StringUtils.appendArray(text, P2LibConst.LINE_SEPARATOR);
        if (((String)log).isEmpty()) {
            return;
        }
        log = errorNumber + P2LibConst.LINE_SEPARATOR + (String)log;
        P2Logger.LogSevere((String)log);
        P2Log.error(errorNumber, null, text);
    }

    public static synchronized void errorLog(int errorNumber, Exception ex, String text) {
        P2Logger.LogSevere(P2Log.addErrNr(errorNumber, text), ex);
        P2Log.error(errorNumber, ex, new String[]{text});
    }

    public static synchronized void errorLog(int errorNumber, Exception ex, String[] text) {
        Object log = P2StringUtils.appendArray(text, P2LibConst.LINE_SEPARATOR);
        if (((String)log).isEmpty()) {
            return;
        }
        log = errorNumber + P2LibConst.LINE_SEPARATOR + (String)log;
        P2Logger.LogSevere((String)log, ex);
        P2Log.error(errorNumber, ex, text);
    }

    public static synchronized void sysLog(String text) {
        P2Logger.LogInfo(text);
        P2Log.resetProgress();
    }

    public static synchronized void sysLog(String[] text) {
        String log = P2StringUtils.appendArray(text, P2LibConst.LINE_SEPARATOR);
        if (log.isEmpty()) {
            return;
        }
        P2Logger.LogInfo(log);
        P2Log.resetProgress();
    }

    public static synchronized void sysLog(List<String> list) {
        String log = P2StringUtils.appendList(list, P2LibConst.LINE_SEPARATOR);
        if (log.isEmpty()) {
            return;
        }
        P2Logger.LogInfo(log);
        P2Log.resetProgress();
    }

    public static synchronized void debugLogCount(String text) {
        if (!P2LibConst.debug) {
            return;
        }
        P2Logger.LogDebug("<==: " + ++COUNT + " :==>  - " + text);
        P2Log.resetProgress();
    }

    public static synchronized void debugLog(String text) {
        if (!P2LibConst.debug) {
            return;
        }
        P2Logger.LogDebug(text);
        P2Log.resetProgress();
    }

    public static synchronized void debugLog(String[] text) {
        if (!P2LibConst.debug) {
            return;
        }
        String log = P2StringUtils.appendArray(text, P2LibConst.LINE_SEPARATOR);
        if (log.isEmpty()) {
            return;
        }
        P2Logger.LogDebug(log);
        P2Log.resetProgress();
    }

    public static synchronized void debugLog(List<String> list) {
        if (!P2LibConst.debug) {
            return;
        }
        String log = P2StringUtils.appendList(list, P2LibConst.LINE_SEPARATOR);
        if (log.isEmpty()) {
            return;
        }
        P2Logger.LogDebug(log);
        P2Log.resetProgress();
    }

    private static String addErrNr(int errNr, String txt) {
        return errNr + LILNE_EMPTY + txt;
    }

    private static void error(int errorNumber, Exception ex, String[] texte) {
        Object kl;
        Throwable t = new Throwable();
        StackTraceElement methodCaller = t.getStackTrace()[2];
        String klasse = methodCaller.getClassName() + "." + methodCaller.getMethodName();
        try {
            kl = klasse;
            while (((String)kl).contains(".") && !Character.isUpperCase(((String)kl).charAt(0))) {
                kl = ((String)kl).substring(((String)kl).indexOf(46) + 1);
            }
        }
        catch (Exception ignored) {
            kl = klasse;
        }
        P2Log.countError(errorNumber, (String)kl, ex != null);
        P2Log.resetProgress();
    }

    private static void countError(int no, String classs, boolean exception) {
        for (Error e : errorList) {
            if (e.errorNr != no) continue;
            ++e.count;
            return;
        }
        errorList.add(new Error(no, classs, exception));
    }

    private static void resetProgress() {
        if (progress) {
            System.out.print("                                                                                                             \r");
            progress = false;
        }
    }

    static class Error {
        String callClass = "";
        int errorNr = 0;
        int count = 0;
        boolean ex = false;

        public Error(int errorNr, String callClass, boolean ex) {
            this.errorNr = errorNr;
            this.callClass = callClass;
            this.ex = ex;
            this.count = 1;
        }
    }
}

