/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools.file;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.dialogs.P2DialogFileChooser;
import de.p2tools.p2lib.tools.P2InfoFactory;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.stage.Stage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;

public class P2FileUtils {
    private static final int WIN_MAX_PATH_LENGTH = 250;
    private static final int X_MAX_NAME_LENGTH = 250;

    public static boolean pathIsEmpty(String path) {
        return P2FileUtils.pathIsEmpty(Path.of(path, new String[0]));
    }

    public static boolean pathIsEmpty(Path path) {
        block8: {
            boolean bl;
            block9: {
                if (!Files.isDirectory(path, new LinkOption[0])) break block8;
                DirectoryStream<Path> directory = Files.newDirectoryStream(path);
                try {
                    boolean bl2 = bl = !directory.iterator().hasNext();
                    if (directory == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (directory != null) {
                            try {
                                directory.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        P2Log.errorLog(645120789, ex.getLocalizedMessage());
                    }
                }
                directory.close();
            }
            return bl;
        }
        return false;
    }

    public static int countFilesInDirectory(String directory) {
        File dir = new File(directory);
        return P2FileUtils.countFilesInDirectory(dir);
    }

    public static int countFilesInDirectory(File directory) {
        int count = 0;
        for (File file : directory.listFiles()) {
            if (file.isFile()) {
                ++count;
            }
            if (!file.isDirectory()) continue;
            count += P2FileUtils.countFilesInDirectory(file);
        }
        return count;
    }

    public static String getParentPath(String path) {
        try {
            File f = new File(path);
            f = f.getParentFile();
            return f.getAbsolutePath();
        }
        catch (Exception ex) {
            P2Log.errorLog(310245789, ex, path);
            new P2Alert();
            P2Alert.showErrorAlert("Elternverzeichnis", "Das Elternverzeichnis von:" + P2LibConst.LINE_SEPARATOR + path + P2LibConst.LINE_SEPARATORx2 + "kann nicht gefunden werden.");
            return "";
        }
    }

    public static String addsPath(String path1, String path2) {
        String ret = "";
        try {
            ret = Paths.get(path1, new String[0]).resolve(path2).toString();
            if (ret.isEmpty()) {
                P2Log.errorLog(283946015, path1 + " - " + path2);
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(375341950, ex, path1 + " - " + path2);
        }
        return ret;
    }

    public static boolean fileExist(String file) {
        return file != null && !file.isEmpty() && new File(file).exists();
    }

    public static boolean fileExist(File file) {
        return file != null && file.exists();
    }

    public static boolean fileIsDirectoryExist(String file) {
        if (!P2FileUtils.fileExist(file)) {
            return false;
        }
        return new File(file).isDirectory();
    }

    public static boolean movePath(String from, String to) {
        if (from.isEmpty()) {
            new P2Alert();
            P2Alert.showErrorAlert("Verzeichnis verschieben", "Das Quellverzeichnis:" + P2LibConst.LINE_SEPARATOR + from + P2LibConst.LINE_SEPARATORx2 + "ist kein Verzeichnis");
            return false;
        }
        if (to.isEmpty()) {
            new P2Alert();
            P2Alert.showErrorAlert("Verzeichnis verschieben", "Das Zielverzeichnis:" + P2LibConst.LINE_SEPARATOR + to + P2LibConst.LINE_SEPARATORx2 + "ist kein Verzeichnis");
            return false;
        }
        try {
            Path src = Paths.get(from, new String[0]);
            Path dest = Paths.get(to, new String[0]);
            if (dest.toFile().exists() && !dest.toFile().isDirectory()) {
                new P2Alert();
                P2Alert.showErrorAlert("Verzeichnis verschieben", "Das Zielverzeichnis:" + P2LibConst.LINE_SEPARATOR + to + P2LibConst.LINE_SEPARATORx2 + "ist kein Verzeichnis");
                return false;
            }
            if (dest.toFile().exists() && dest.toFile().isDirectory() && dest.toFile().list().length > 0) {
                new P2Alert();
                P2Alert.showErrorAlert("Verzeichnis verschieben", "Das Zielverzeichnis:" + P2LibConst.LINE_SEPARATOR + to + P2LibConst.LINE_SEPARATORx2 + "existiert bereits und ist nicht leer!");
                return false;
            }
            if (dest.toFile().exists() && dest.toFile().isDirectory() && dest.toFile().list().length == 0) {
                dest.toFile().delete();
            }
            FileUtils.moveDirectory(src.toFile(), dest.toFile());
        }
        catch (IOException ex) {
            P2Log.errorLog(645121047, "move path: " + from + " to " + to);
            return false;
        }
        return true;
    }

    public static boolean copyFile(Path from, Path dest) {
        return P2FileUtils.copyFile(from, dest, true);
    }

    public static boolean copyFile(Path from, Path dest, boolean ask) {
        try {
            P2Alert.BUTTON button;
            if (from.toString().isEmpty()) {
                new P2Alert();
                P2Alert.showErrorAlert("Datei kopieren", "Es wurde keine Quelldatei angegeben.");
                return false;
            }
            if (dest.toString().isEmpty()) {
                new P2Alert();
                P2Alert.showErrorAlert("Datei kopieren", "Es wurde keine Zieldatei angegeben.");
                return false;
            }
            if (!from.toFile().exists()) {
                new P2Alert();
                P2Alert.showErrorAlert("Datei kopieren", "Die Quelldatei:" + P2LibConst.LINE_SEPARATOR + from.toString() + P2LibConst.LINE_SEPARATORx2 + "existiert nicht.");
                return false;
            }
            if (dest.toFile().isDirectory()) {
                new P2Alert();
                P2Alert.showErrorAlert("Datei kopieren", "Die Zieldatei:" + P2LibConst.LINE_SEPARATOR + dest.toString() + P2LibConst.LINE_SEPARATORx2 + "ist ein Verzeichnis.");
                return false;
            }
            if (ask && dest.toFile().exists() && !(button = P2Alert.showAlert_yes_no("Hinweis", "Datei kopieren", "Die Zieldatei existiert bereits:" + P2LibConst.LINE_SEPARATOR + dest.toString() + P2LibConst.LINE_SEPARATORx2 + "Soll die Datei \u00fcberschrieben werden?")).equals((Object)P2Alert.BUTTON.YES)) {
                return false;
            }
            if (dest.toFile().exists()) {
                dest.toFile().delete();
            }
            FileUtils.copyFile(from.toFile(), dest.toFile());
        }
        catch (IOException ex) {
            P2Log.errorLog(978451203, "copy file: " + from.toString() + " to " + dest.toString());
            return false;
        }
        return true;
    }

    public static boolean checkFileToCreate(Stage stage, Path pathToCheck) {
        if (pathToCheck.toString().isEmpty()) {
            new P2Alert();
            P2Alert.showErrorAlert(stage, "Datei anlegen", "Es wurde keine Datei angegeben.");
            return false;
        }
        if (pathToCheck.toFile().exists()) {
            P2Alert.BUTTON button = P2Alert.showAlert_yes_no(stage, "Hinweis", "Datei anlegen", "Die Datei exisiert bereits:" + P2LibConst.LINE_SEPARATOR + pathToCheck.toString() + P2LibConst.LINE_SEPARATORx2 + "Soll die Datei \u00fcberschrieben werden?");
            if (!button.equals((Object)P2Alert.BUTTON.YES)) {
                return false;
            }
            if (!pathToCheck.toFile().delete()) {
                new P2Alert();
                P2Alert.showErrorAlert(stage, "Datei l\u00f6schen", "Die Datei: \n" + String.valueOf(pathToCheck.toFile()) + "\nkann nicht gel\u00f6scht werden.");
                return false;
            }
            if (pathToCheck.toFile().exists()) {
                P2Alert.showErrorAlert(stage, "Fehler", "Zieldatei existiert bereits!", "Die Zieldatei kann nicht \u00fcberschrieben werden.");
                return false;
            }
        }
        return true;
    }

    public static void checkLengthPath(String[] pathName) {
        if (SystemUtils.IS_OS_WINDOWS) {
            if (pathName[0].length() + 10 > 250) {
                P2Log.errorLog(102036598, "Pfad zu lang: " + pathName[0]);
                pathName[0] = P2InfoFactory.getHomePath();
            }
            if (pathName[0].length() + pathName[1].length() > 250) {
                P2Log.errorLog(902367369, "Name zu lang: " + pathName[0]);
                int maxNameL = 250 - pathName[0].length();
                pathName[1] = P2FileUtils.cutName(pathName[1], maxNameL);
            }
        } else if (pathName[1].length() > 250) {
            P2Log.errorLog(823012012, "Name zu lang: " + pathName[1]);
            pathName[1] = P2FileUtils.cutName(pathName[1], 250);
        }
    }

    public static String cutName(String name, int length) {
        if (length < 10) {
            length = 10;
        }
        if (((String)name).length() > length) {
            name = ((String)name).substring(0, length - 4) + ((String)name).substring(((String)name).length() - 4);
        }
        return name;
    }

    public static String getHash(String path) {
        int h = path.hashCode();
        h = Math.abs(h);
        String hh = "" + h;
        while (hh.length() < 10) {
            hh = "0" + hh;
        }
        return hh;
    }

    public static String getFileNameSuffix(String path) {
        String suff = "";
        try {
            suff = FilenameUtils.getExtension(path);
            if (suff == null || suff.isEmpty()) {
                return "";
            }
        }
        catch (Exception ignore) {
            return "";
        }
        return suff;
    }

    public static String getFileName(String path) {
        String name = "";
        try {
            name = FilenameUtils.getName(path);
            if (name == null || name.isEmpty()) {
                return "";
            }
        }
        catch (Exception ignore) {
            return "";
        }
        return name;
    }

    public static String getFileNameWithOutExtension(String path) {
        String nameWithOutSuff;
        try {
            nameWithOutSuff = P2FileUtils.getFileName(path);
            nameWithOutSuff = FilenameUtils.removeExtension(nameWithOutSuff);
            if (nameWithOutSuff == null || nameWithOutSuff.isEmpty()) {
                return "";
            }
        }
        catch (Exception ignore) {
            return "";
        }
        return nameWithOutSuff;
    }

    public static String removeFileNameSuffix(String path) {
        String noSuff;
        try {
            noSuff = FilenameUtils.removeExtension(path);
            if (noSuff == null || noSuff.isEmpty()) {
                return "";
            }
        }
        catch (Exception ignore) {
            return "";
        }
        return noSuff;
    }

    public static String getPath(String path) {
        String ret = "";
        if (path != null && !path.isEmpty() && path.contains(File.separator)) {
            ret = path.substring(0, path.lastIndexOf(File.separator));
        }
        if (ret.isEmpty()) {
            ret = path;
            P2Log.errorLog(915201236, path);
        }
        return ret;
    }

    public static long getFreeDiskSpace(String strPath) {
        long usableSpace = 0L;
        if (!strPath.isEmpty()) {
            try {
                Path path = Paths.get(strPath, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    path = path.getParent();
                }
                FileStore fileStore = Files.getFileStore(path);
                usableSpace = fileStore.getUsableSpace();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return usableSpace;
    }

    public static boolean deleteFile(String strFile) {
        boolean ret = false;
        try {
            File file = new File(strFile);
            if (!file.exists()) {
                new P2DialogFileChooser();
                P2DialogFileChooser.showErrorAlert("Datei l\u00f6schen", "", "Die Datei existiert nicht!");
                return false;
            }
            new P2DialogFileChooser();
            if (P2DialogFileChooser.showAlertOkCancel("Datei L\u00f6schen?", "", "Die Datei l\u00f6schen:" + P2LibConst.LINE_SEPARATORx2 + strFile)) {
                P2Log.sysLog(new String[]{"Datei l\u00f6schen: ", file.getAbsolutePath()});
                if (!file.delete()) {
                    throw new Exception();
                }
                ret = true;
            }
        }
        catch (Exception ex) {
            ret = false;
            new P2DialogFileChooser();
            P2DialogFileChooser.showErrorAlert("Datei l\u00f6schen", "Konnte die Datei nicht l\u00f6schen!", "Fehler beim l\u00f6schen von:" + P2LibConst.LINE_SEPARATORx2 + strFile);
            P2Log.errorLog(987451206, "Fehler beim l\u00f6schen: " + strFile);
        }
        return ret;
    }

    public static boolean deleteFileNoMsg(String strFile) {
        boolean ret = false;
        try {
            File file = new File(strFile);
            if (!file.exists()) {
                new P2DialogFileChooser();
                P2DialogFileChooser.showErrorAlert("Datei l\u00f6schen", "", "Die Datei existiert nicht!");
                return false;
            }
            P2Log.sysLog(new String[]{"Datei l\u00f6schen: ", file.getAbsolutePath()});
            if (!file.delete()) {
                throw new Exception();
            }
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
            new P2DialogFileChooser();
            P2DialogFileChooser.showErrorAlert("Datei l\u00f6schen", "Konnte die Datei nicht l\u00f6schen!", "Fehler beim l\u00f6schen von:" + P2LibConst.LINE_SEPARATORx2 + strFile);
            P2Log.errorLog(302015478, "Fehler beim l\u00f6schen: " + strFile);
        }
        return ret;
    }
}

