/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.filmlistload;

import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.mediathek.filmlistload.P2LoadConst;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.zip.ZipInputStream;
import javafx.application.Platform;
import javafx.stage.Stage;
import org.tukaani.xz.XZInputStream;

public class P2LoadFactory {
    private P2LoadFactory() {
    }

    public static ArrayList<String> getSenderListNotToLoad() {
        return new ArrayList<String>(Arrays.asList(P2LoadConst.SYSTEM_LOAD_NOT_SENDER.split(",")));
    }

    public static boolean checkAllSenderSelectedNotToLoad(Stage stage) {
        ArrayList<String> aListSenderNotToLoad = P2LoadFactory.getSenderListNotToLoad();
        boolean allSender = true;
        for (String sender : P2LoadConst.SENDER) {
            Optional<String> optional = aListSenderNotToLoad.stream().filter(aktSender -> aktSender.equals(sender)).findAny();
            if (!optional.isEmpty()) continue;
            allSender = false;
            break;
        }
        if (allSender) {
            Platform.runLater(() -> P2Alert.showErrorAlert(stage, "Sender laden", "Es werden keine Filme geladen. Alle Sender sind vom Laden ausgenommen!\n\nEinstellungen -> Filmliste laden"));
        }
        return allSender;
    }

    public static InputStream selectDecompressor(String source2, InputStream in) throws Exception {
        if (source2.endsWith(".xz")) {
            in = new XZInputStream(in);
        } else if (source2.endsWith(".zip")) {
            ZipInputStream zipInputStream = new ZipInputStream(in);
            zipInputStream.getNextEntry();
            in = zipInputStream;
        }
        return in;
    }
}

