/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.download;

import de.p2tools.p2lib.mediathek.download.DownloadSizeData;
import de.p2tools.p2lib.mediathek.tools.P2SizeTools;
import de.p2tools.p2lib.tools.log.P2Log;
import javafx.beans.property.ObjectPropertyBase;

public class DownloadSize
extends ObjectPropertyBase<DownloadSizeData>
implements Comparable<DownloadSize> {
    private long actuallySize = 0L;
    private Long targetSize = 0L;

    @Override
    public void setValue(DownloadSizeData v) {
        super.setValue(v);
        this.targetSize = v.l;
    }

    @Override
    public DownloadSizeData getValue() {
        return (DownloadSizeData)super.getValue();
    }

    @Override
    public final DownloadSizeData get() {
        return new DownloadSizeData(this.targetSize, this.getString());
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public String getName() {
        return "DownloadSize";
    }

    @Override
    public int compareTo(DownloadSize ll) {
        return this.targetSize.compareTo(ll.targetSize);
    }

    @Override
    public String toString() {
        return this.getString();
    }

    public void setTargetSize(String size) {
        if (size.isEmpty()) {
            this.actuallySize = 0L;
            this.targetSize = 0L;
        } else {
            try {
                this.targetSize = Long.valueOf(size);
                this.targetSize = this.targetSize * 1000L * 1000L;
            }
            catch (Exception ex) {
                P2Log.errorLog(978745320, ex, "String: " + size);
                this.targetSize = 0L;
            }
        }
        this.fireValueChangedEvent();
    }

    public void setTargetSize(long l) {
        this.targetSize = l;
        this.fireValueChangedEvent();
    }

    public long getTargetSize() {
        return this.targetSize;
    }

    public String getTargetSizeStr() {
        if (this.targetSize == 0L) {
            return "";
        }
        return "" + this.targetSize;
    }

    public String getTargetSizeMBStr() {
        return P2SizeTools.getSize(this.targetSize);
    }

    public void setActuallySize(long l) {
        this.actuallySize = l;
        if (this.targetSize < this.actuallySize) {
            this.targetSize = this.actuallySize;
        }
        this.fireValueChangedEvent();
    }

    public void addActFileSize(long l) {
        this.actuallySize += l;
        if (this.targetSize < this.actuallySize) {
            this.targetSize = this.actuallySize;
        }
        this.fireValueChangedEvent();
    }

    public long getActuallySize() {
        return this.actuallySize;
    }

    public void clearSize() {
        this.targetSize = 0L;
        this.actuallySize = 0L;
    }

    public void resetActFileSize() {
        this.actuallySize = 0L;
        this.fireValueChangedEvent();
    }

    private String getString() {
        if (this.actuallySize <= 0L) {
            if (this.targetSize > 0L) {
                return P2SizeTools.getSize(this.targetSize);
            }
            return "";
        }
        if (this.targetSize == this.actuallySize) {
            return P2SizeTools.getSize(this.targetSize);
        }
        if (this.targetSize > 0L) {
            return P2SizeTools.getSize(this.actuallySize) + " von " + P2SizeTools.getSize(this.targetSize);
        }
        return P2SizeTools.getSize(this.actuallySize);
    }
}

