/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.download;

import de.p2tools.p2lib.mediathek.filmlistload.P2LoadConst;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.net.P2UrlConnectionFactory;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class DownloadFactory {
    private DownloadFactory() {
    }

    public static HttpURLConnection getConn(String urlStr, String userAgent, int timeOutSec, long downloaded, boolean sslAlways) {
        try {
            URL url = new URL(urlStr);
            return DownloadFactory.getConn(url, userAgent, timeOutSec, downloaded, sslAlways);
        }
        catch (Exception ex) {
            P2Log.errorLog(451214789, ex, "DownloadFactory.getConn");
            return null;
        }
    }

    public static HttpURLConnection getConn(URL url, String userAgent, int timeOutSec, long downloaded, boolean sslAlways) {
        HttpURLConnection conn = null;
        try {
            conn = P2UrlConnectionFactory.getUrlConnection(url);
            conn.setConnectTimeout(1000 * timeOutSec);
            conn.setReadTimeout(1000 * timeOutSec);
            if (sslAlways && conn instanceof HttpsURLConnection) {
                HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
                httpsConn.setHostnameVerifier((hostname, session) -> true);
            }
            conn.setRequestProperty("Range", "bytes=" + downloaded + "-");
            conn.setRequestProperty("User-Agent", userAgent);
            conn.setDoInput(true);
            conn.setDoOutput(true);
        }
        catch (Exception ex) {
            P2Log.errorLog(959868547, ex, "DownloadFactory.getConn");
        }
        return conn;
    }

    public static String getContentLengthMB(String url) {
        String sizeStr = "";
        try {
            long l = DownloadFactory.getContentLength(new URL(url), false);
            if (l > 1000000L) {
                sizeStr = String.valueOf(l / 1000000L);
            } else if (l > 0L) {
                sizeStr = "1";
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(102589746, ex, "DownloadFactory.getFileSizeFromUrl");
        }
        return sizeStr;
    }

    public static long getContentLength(URL url) {
        return DownloadFactory.getContentLength(url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getContentLength(URL url, boolean playlist) {
        int TIMEOUT_LENGTH = 5000;
        long ret = -1L;
        HttpURLConnection connection = null;
        try {
            connection = P2UrlConnectionFactory.getUrlConnection(url);
            connection.setRequestProperty("User-Agent", P2LoadConst.userAgent);
            connection.setReadTimeout(5000);
            connection.setConnectTimeout(5000);
            if (connection.getResponseCode() < 400) {
                ret = connection.getContentLengthLong();
            }
            if (playlist && ret < 300000L) {
                ret = -1L;
            }
        }
        catch (Exception ex) {
            ret = -1L;
            P2Log.errorLog(643298301, ex, "URL: " + String.valueOf(url));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return ret;
    }
}

