/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools.pmask;

import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class P2MaskerPane
extends BorderPane {
    private final ProgressIndicator progressIndicator = new ProgressIndicator();
    private boolean txtBtnHorizontal = true;
    private final VBox vBoxCont = new VBox();
    private final Label lblText = new Label("");
    private final Button btnStop = new Button("Stop");

    public P2MaskerPane() {
        this.getStyleClass().add("p2MaskerPane");
        this.lblText.getStyleClass().add("p2MaskerTextLabel");
        this.btnStop.getStyleClass().add("p2MaskerButtonStop");
        this.progressIndicator.getStyleClass().add("p2MaskerProgressIndicator");
        this.setVBoxCont();
        this.setCenter(this.vBoxCont);
        this.setVisible(false);
    }

    public BooleanProperty getVisibleProperty() {
        return this.visibleProperty();
    }

    public void bindVisibleProperty(BooleanProperty visible) {
        this.visibleProperty().bind(visible);
    }

    public Button getButton() {
        return this.btnStop;
    }

    public void setButtonText(String text) {
        Platform.runLater(() -> this.btnStop.setText(text));
    }

    public void setButtonVisible(boolean buttonVisible) {
        Platform.runLater(() -> this.setBtnVisible(buttonVisible));
    }

    public void setTextVisible(boolean textVisible) {
        Platform.runLater(() -> this.setLblVisible(textVisible));
    }

    public void setMaskerText(String text) {
        Platform.runLater(() -> this.lblText.setText(text));
    }

    public void switchOffMasker() {
        this.setMaskerVisible(false, false, false);
    }

    public void setMaskerVisible() {
        Platform.runLater(() -> {
            this.setPaneVisible(true);
            this.setLblVisible(true);
            this.setBtnVisible(true);
        });
    }

    public void setMaskerVisible(boolean maskerVisible, boolean textVisible, boolean buttonVisible) {
        Platform.runLater(() -> {
            this.setPaneVisible(maskerVisible);
            this.setLblVisible(textVisible);
            this.setBtnVisible(buttonVisible);
        });
    }

    public void setMaskerProgress(double progress, String text) {
        Platform.runLater(() -> this.setProgress(progress, text));
    }

    public void setMaskerProgressIndeterminate() {
        Platform.runLater(() -> this.setProgress(-1.0, ""));
    }

    public boolean isTxtBtnHorizontal() {
        return this.txtBtnHorizontal;
    }

    public void setTxtBtnHorizontal(boolean txtBtnHorizontal) {
        this.txtBtnHorizontal = txtBtnHorizontal;
        this.setVBoxCont();
    }

    private void setBtnVisible(boolean visible) {
        this.btnStop.setVisible(visible);
        this.btnStop.setManaged(visible);
    }

    private void setLblVisible(boolean visible) {
        this.lblText.setVisible(visible);
        this.lblText.setManaged(visible);
    }

    private void setPaneVisible(boolean visible) {
        this.setVisible(visible);
        this.progressIndicator.setVisible(visible);
    }

    private void setVBoxCont() {
        this.vBoxCont.getChildren().clear();
        this.vBoxCont.setMinWidth(500.0);
        this.vBoxCont.setMaxWidth(500.0);
        this.vBoxCont.setSpacing(20.0);
        this.vBoxCont.setPadding(new Insets(20.0));
        this.vBoxCont.setAlignment(Pos.CENTER);
        this.progressIndicator.setMaxSize(120.0, 120.0);
        this.progressIndicator.setMinSize(120.0, 120.0);
        this.lblText.setMaxWidth(Double.MAX_VALUE);
        this.lblText.setAlignment(Pos.CENTER);
        this.lblText.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        this.lblText.setMinHeight(this.btnStop.getHeight());
        this.setBtnVisible(false);
        if (this.txtBtnHorizontal) {
            HBox hBox = new HBox(10.0);
            hBox.setAlignment(Pos.CENTER);
            HBox.setHgrow(this.lblText, Priority.ALWAYS);
            hBox.getChildren().addAll((Node[])new Node[]{this.lblText, this.btnStop});
            this.vBoxCont.getChildren().addAll((Node[])new Node[]{this.progressIndicator, hBox});
        } else {
            VBox vBox = new VBox(10.0);
            vBox.setAlignment(Pos.CENTER);
            vBox.getChildren().addAll((Node[])new Node[]{this.lblText, this.btnStop});
            this.vBoxCont.getChildren().addAll((Node[])new Node[]{this.progressIndicator, vBox});
        }
    }

    private void setProgress(double progress, String text) {
        this.progressIndicator.setProgress(progress);
        this.lblText.setText(text);
    }
}

