/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import de.p2tools.p2lib.tools.date.P2LTimeFactory;
import java.time.LocalTime;
import java.util.ArrayList;
import javafx.scene.control.ComboBox;

public class P2TimePicker
extends ComboBox<LocalTime> {
    private int addMinutes = 15;
    private boolean fromNow = false;

    public P2TimePicker() {
        LocalTime l = LocalTime.now().plusMinutes(this.addMinutes);
        LocalTime startTime = LocalTime.of(l.getHour(), l.getMinute());
        this.init(startTime);
    }

    public P2TimePicker(boolean fromNow) {
        this.fromNow = fromNow;
        LocalTime l = LocalTime.now().plusMinutes(this.addMinutes);
        LocalTime startTime = LocalTime.of(l.getHour(), l.getMinute());
        this.init(startTime);
    }

    public P2TimePicker(int addMinutes) {
        this.addMinutes = addMinutes;
        LocalTime l = LocalTime.now();
        LocalTime startTime = LocalTime.of(l.getHour(), l.getMinute());
        this.init(startTime);
    }

    public P2TimePicker(LocalTime startTime, int addMinutes) {
        this.addMinutes = addMinutes;
        this.init(startTime);
    }

    private void init(LocalTime startTime) {
        LocalTime pl = LocalTime.ofSecondOfDay(0L);
        ArrayList<LocalTime> list = new ArrayList<LocalTime>();
        LocalTime plSelect = pl;
        for (int h = 0; h < 24; ++h) {
            for (int m = 0; m < 60; m += this.addMinutes) {
                pl = LocalTime.of(h, m);
                if (!pl.isAfter(LocalTime.now()) && !this.fromNow) {
                    list.add(pl);
                } else if (pl.isAfter(LocalTime.now())) {
                    list.add(pl);
                }
                if (pl.isAfter(startTime)) continue;
                plSelect = pl;
            }
        }
        this.getItems().addAll(list);
        this.getSelectionModel().select(plSelect);
    }

    public void removeTime() {
        this.setValue(null);
    }

    public LocalTime getLocalTime() {
        return (LocalTime)this.getValue();
    }

    public void clearTime() {
        this.setValue(null);
    }

    public String getTime() {
        return P2LTimeFactory.toString_HM((LocalTime)this.getValue());
    }

    public void setTime(LocalTime localTime) {
        this.getSelectionModel().select(localTime);
    }

    public void setTime(String stringDate) {
        if (stringDate == null || stringDate.isEmpty()) {
            this.setValue(null);
        } else {
            LocalTime pLocalTime = stringDate.length() == 5 ? P2LTimeFactory.fromString_HM(stringDate) : P2LTimeFactory.fromString(stringDate);
            this.getSelectionModel().select(pLocalTime);
        }
    }
}

