/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import de.p2tools.p2lib.guitools.P2Styles;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.TextField;
import javafx.util.converter.NumberStringConverter;

public class P2TextFieldMoney
extends TextField {
    private static final Locale locale = Locale.GERMAN;
    private static final NumberFormat NF = NumberFormat.getNumberInstance(locale);
    private static final DecimalFormat DF = new DecimalFormat("###,##0.00 \u20ac");
    private LongProperty longProperty = null;
    private ChangeListener lChangeListener = null;
    private DoubleProperty doubleProperty = null;
    private ChangeListener dChangeListener = null;
    private DoubleBinding db = null;
    private boolean onlyLabel = false;
    private boolean labelLike = false;

    public P2TextFieldMoney() {
        this.textProperty().addListener((observable2, oldValue, newValue) -> this.setTextStyle(this.getText()));
    }

    public P2TextFieldMoney(boolean onlyLabel) {
        this.onlyLabel = onlyLabel;
        this.labelLike = onlyLabel;
        this.setLabelLike();
        this.textProperty().addListener((observable2, oldValue, newValue) -> this.setTextStyle(this.getText()));
    }

    public P2TextFieldMoney(LongProperty longProperty, boolean onlyLabel) {
        this.longProperty = longProperty;
        this.onlyLabel = onlyLabel;
        this.labelLike = onlyLabel;
        this.setLabelLike();
        this.bindBidirectional();
    }

    public void setLabelLike(boolean stateLikeLabel) {
        this.labelLike = stateLikeLabel;
        this.setLabelLike();
    }

    private void setLabelLike() {
        this.setEditable(!this.labelLike);
        this.setStyle(this.labelLike ? P2Styles.PTEXTFIELD_LABEL : "");
    }

    public void bindBidirectional(LongProperty longProperty) {
        this.longProperty = longProperty;
        this.bindBidirectional();
    }

    public void bindBidirectional() {
        if (this.longProperty == null) {
            this.unBind();
            return;
        }
        this.lChangeListener = (observable2, oldValue, newValue) -> this.doubleProperty.set(0.01 * (double)this.longProperty.get());
        this.longProperty.addListener(this.lChangeListener);
        this.doubleProperty = new SimpleDoubleProperty();
        this.doubleProperty.set(0.01 * (double)this.longProperty.get());
        if (!this.onlyLabel) {
            this.dChangeListener = (observable2, oldValue, newValue) -> {
                double d = this.doubleProperty.get() * 100.0;
                this.longProperty.set(Math.round(d));
            };
            this.doubleProperty.addListener(this.dChangeListener);
        }
        Bindings.bindBidirectional((Property<String>)this.textProperty(), this.doubleProperty, new NumberStringConverter(DF){

            @Override
            public Number fromString(String value) {
                Number ret = 0;
                P2TextFieldMoney.this.setTextStyle(value);
                try {
                    if (value == null) {
                        return null;
                    }
                    if ((value = value.trim()).length() < 1) {
                        return null;
                    }
                    ret = NF.parse(value);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                return ret;
            }
        });
    }

    public void unBind() {
        if (this.doubleProperty != null) {
            this.textProperty().unbindBidirectional((Object)this.doubleProperty);
            if (this.dChangeListener != null) {
                this.doubleProperty.removeListener(this.dChangeListener);
            }
        }
        if (this.longProperty != null && this.lChangeListener != null) {
            this.longProperty.removeListener(this.lChangeListener);
        }
        this.doubleProperty = null;
        this.dChangeListener = null;
        this.lChangeListener = null;
    }

    private void setTextStyle(String value) {
        this.setStyle(this.labelLike ? P2Styles.PTEXTFIELD_LABEL : "");
        if (value == null || value.trim().isEmpty()) {
            return;
        }
        try {
            NF.parse(value.trim());
        }
        catch (ParseException ex) {
            this.setStyle(this.labelLike ? P2Styles.PTEXTFIELD_LABEL_ERROR : P2Styles.PTEXTFIELD_ERROR);
        }
    }
}

