/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import de.p2tools.p2lib.guitools.P2Styles;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.scene.control.TextField;
import javafx.util.converter.NumberStringConverter;

public class P2TextFieldDouble
extends TextField {
    private static final Locale locale = Locale.GERMAN;
    private static final NumberFormat NF = NumberFormat.getNumberInstance(locale);
    private static final DecimalFormat DF = new DecimalFormat("###,##0.00");
    private DoubleProperty doubleProperty = null;
    private boolean stateLikeLabel = false;

    public P2TextFieldDouble() {
        this.textProperty().addListener((observable2, oldValue, newValue) -> this.setTextStyle(this.getText()));
    }

    public P2TextFieldDouble(boolean stateLikeLabel) {
        this.stateLikeLabel = stateLikeLabel;
        this.setStateLikeLabel();
        this.textProperty().addListener((observable2, oldValue, newValue) -> this.setTextStyle(this.getText()));
    }

    public P2TextFieldDouble(DoubleProperty doubleProperty) {
        this.doubleProperty = doubleProperty;
        this.bindBidirectional();
    }

    public P2TextFieldDouble(DoubleProperty doubleProperty, boolean stateLikeLabel) {
        this.doubleProperty = doubleProperty;
        this.stateLikeLabel = stateLikeLabel;
        this.setStateLikeLabel();
        this.bindBidirectional();
    }

    public void setStateLikeLabel(boolean stateLikeLabel) {
        this.stateLikeLabel = stateLikeLabel;
        this.setStateLikeLabel();
    }

    private void setStateLikeLabel() {
        this.setEditable(!this.stateLikeLabel);
        if (this.stateLikeLabel) {
            this.setStyle(P2Styles.PTEXTFIELD_LABEL);
        }
    }

    public DoubleProperty getDoubleProperty() {
        return this.doubleProperty;
    }

    public void setDoubleProperty(DoubleProperty doubleProperty) {
        this.unBind();
        this.doubleProperty = doubleProperty;
        this.bindBidirectional();
    }

    public double getDouble() {
        return this.doubleProperty.get();
    }

    public void setText(Double text) {
        this.setText(DF.format(text));
    }

    public void bindBidirectional(DoubleProperty doubleProperty) {
        this.doubleProperty = doubleProperty;
        this.bindBidirectional();
    }

    public void bindBidirectional() {
        if (this.doubleProperty == null) {
            return;
        }
        Bindings.bindBidirectional((Property<String>)this.textProperty(), this.doubleProperty, new NumberStringConverter(new DecimalFormat("###,##0.00")){

            @Override
            public Number fromString(String value) {
                Number ret = 0;
                P2TextFieldDouble.this.setTextStyle(value);
                try {
                    if (value == null) {
                        return null;
                    }
                    if ((value = value.trim()).length() < 1) {
                        return null;
                    }
                    ret = NF.parse(value);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                return ret;
            }
        });
    }

    public void unBind() {
        if (this.doubleProperty == null) {
            return;
        }
        this.textProperty().unbindBidirectional((Object)this.doubleProperty);
    }

    private void setTextStyle(String value) {
        this.setStyle(this.stateLikeLabel ? P2Styles.PTEXTFIELD_LABEL : "");
        if (value == null || value.trim().isEmpty()) {
            return;
        }
        try {
            NF.parse(value.trim());
        }
        catch (ParseException ex) {
            this.setStyle(this.stateLikeLabel ? P2Styles.PTEXTFIELD_LABEL_ERROR : P2Styles.PTEXTFIELD_ERROR);
        }
    }
}

