/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;

public class P2TextAreaIgnoreTab
extends TextArea {
    final TextArea textArea = this;
    final boolean enter;
    final boolean tab;

    public P2TextAreaIgnoreTab(boolean enter, boolean tab) {
        this.enter = enter;
        this.tab = tab;
        this.addEventFilter(KeyEvent.KEY_PRESSED, new TabAndEnterHandler());
    }

    class TabAndEnterHandler
    implements EventHandler<KeyEvent> {
        private KeyEvent recodedEvent;

        TabAndEnterHandler() {
        }

        @Override
        public void handle(KeyEvent event) {
            if (this.recodedEvent != null) {
                this.recodedEvent = null;
                return;
            }
            Parent parent = P2TextAreaIgnoreTab.this.textArea.getParent();
            if (parent != null) {
                switch (event.getCode()) {
                    case ENTER: {
                        if (!P2TextAreaIgnoreTab.this.enter) break;
                        if (event.isControlDown()) {
                            this.recodedEvent = this.recodeWithoutControlDown(event);
                            P2TextAreaIgnoreTab.this.textArea.fireEvent(this.recodedEvent);
                        } else {
                            KeyEvent parentEvent = event.copyFor(parent, parent);
                            P2TextAreaIgnoreTab.this.textArea.getParent().fireEvent(parentEvent);
                        }
                        event.consume();
                        break;
                    }
                    case TAB: {
                        if (!P2TextAreaIgnoreTab.this.tab) break;
                        if (event.isControlDown()) {
                            this.recodedEvent = this.recodeWithoutControlDown(event);
                            P2TextAreaIgnoreTab.this.textArea.fireEvent(this.recodedEvent);
                        } else if (event.isShiftDown()) {
                            ObservableList<Node> children = parent.getChildrenUnmodifiable();
                            int idx = children.indexOf(P2TextAreaIgnoreTab.this.textArea);
                            if (idx < 0) break;
                            this.selPreviousNode(parent, idx);
                        } else {
                            ObservableList<Node> children = parent.getChildrenUnmodifiable();
                            int idx = children.indexOf(P2TextAreaIgnoreTab.this.textArea);
                            if (idx < 0) break;
                            this.selNextNode(parent, idx);
                        }
                        event.consume();
                    }
                }
            }
        }

        private KeyEvent recodeWithoutControlDown(KeyEvent event) {
            return new KeyEvent(event.getEventType(), event.getCharacter(), event.getText(), event.getCode(), event.isShiftDown(), false, event.isAltDown(), event.isMetaDown());
        }

        private boolean selPreviousNode(Parent parent, int startNode) {
            Node n;
            int i;
            ObservableList<Node> children = parent.getChildrenUnmodifiable();
            for (i = startNode - 1; i >= 0; --i) {
                n = (Node)children.get(i);
                if (!n.isFocusTraversable() && n instanceof Region && this.selPreviousNode((Region)n, ((Region)n).getChildrenUnmodifiable().size())) {
                    return true;
                }
                if (!n.isFocusTraversable()) continue;
                n.requestFocus();
                return true;
            }
            for (i = children.size() - 1; i > startNode; --i) {
                n = (Node)children.get(i);
                if (!n.isFocusTraversable() && n instanceof Region && this.selPreviousNode((Region)n, ((Region)n).getChildrenUnmodifiable().size())) {
                    return true;
                }
                if (!n.isFocusTraversable()) continue;
                n.requestFocus();
                return true;
            }
            return false;
        }

        private boolean selNextNode(Parent parent, int startNode) {
            Node n;
            int i;
            ObservableList<Node> children = parent.getChildrenUnmodifiable();
            for (i = startNode + 1; i < children.size(); ++i) {
                n = (Node)children.get(i);
                if (!n.isFocusTraversable() && n instanceof Region && this.selNextNode((Region)n, 0)) {
                    return true;
                }
                if (!n.isFocusTraversable()) continue;
                n.requestFocus();
                return true;
            }
            for (i = 0; i < startNode; ++i) {
                n = (Node)children.get(i);
                if (!n.isFocusTraversable() && n instanceof Region && this.selNextNode((Region)n, 0)) {
                    return true;
                }
                if (!n.isFocusTraversable()) continue;
                n.requestFocus();
                return true;
            }
            return false;
        }
    }
}

