/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import java.text.NumberFormat;
import java.util.HashSet;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.skin.TableViewSkin;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

public class P2TableFactory {
    public static final KeyCombination SPACE = new KeyCodeCombination(KeyCode.SPACE, new KeyCombination.Modifier[0]);
    public static final KeyCombination SPACE_SHIFT = new KeyCodeCombination(KeyCode.SPACE, KeyCombination.SHIFT_DOWN);
    public static final KeyCombination SPACE_ALT = new KeyCodeCombination(KeyCode.SPACE, KeyCombination.ALT_DOWN);
    public static final KeyCombination SPACE_STRG = new KeyCodeCombination(KeyCode.SPACE, KeyCombination.CONTROL_DOWN);
    static NumberFormat currencyFormat = NumberFormat.getCurrencyInstance();

    public static void refreshTable(TableView table) {
        Platform.runLater(() -> {
            for (int i = 0; i < table.getColumns().size(); ++i) {
                if (!((TableColumn)table.getColumns().get(i)).isVisible()) continue;
                ((TableColumn)table.getColumns().get(i)).setVisible(false);
                ((TableColumn)table.getColumns().get(i)).setVisible(true);
            }
        });
    }

    public static void scrollVisibleRangeUp(TableView table) {
        int count;
        if (table.getItems().size() == 0) {
            return;
        }
        if (table.getSelectionModel().getSelectedIndex() == 0) {
            int i = table.getItems().size() - 1;
            table.getSelectionModel().clearAndSelect(i);
            table.scrollTo(i);
            return;
        }
        TableViewSkin skin = (TableViewSkin)table.getSkin();
        if (skin == null) {
            return;
        }
        int[] range = P2TableFactory.getVisibleRange(table);
        int n = range[0] + 2 - (count = range[1] - range[0]);
        if (n < 0) {
            n = 0;
        }
        if (count >= 0 && n < table.getItems().size()) {
            table.getSelectionModel().clearAndSelect(n);
            table.scrollTo(n);
        }
    }

    public static void scrollVisibleRangeDown(TableView table) {
        if (table.getItems().size() == 0) {
            return;
        }
        if (table.getSelectionModel().getSelectedIndex() == table.getItems().size() - 1) {
            table.getSelectionModel().clearAndSelect(0);
            table.scrollTo(0);
            return;
        }
        TableViewSkin skin = (TableViewSkin)table.getSkin();
        if (skin == null) {
            return;
        }
        int[] range = P2TableFactory.getVisibleRange(table);
        int count = range[1] - range[0];
        int n = range[0] + count;
        if (count >= 0 && n < table.getItems().size()) {
            table.getSelectionModel().clearAndSelect(n);
            table.scrollTo(n);
        }
    }

    public static int[] getVisibleRange(TableView table) {
        int indexLast;
        int indexFirst;
        TableViewSkin skin = (TableViewSkin)table.getSkin();
        if (skin == null) {
            return new int[]{0, 0};
        }
        VirtualFlow flow = (VirtualFlow)skin.getChildren().get(1);
        if (flow != null && flow.getFirstVisibleCell() != null && flow.getLastVisibleCell() != null) {
            indexFirst = ((IndexedCell)flow.getFirstVisibleCell()).getIndex();
            if (indexFirst >= table.getItems().size()) {
                indexFirst = table.getItems().size() - 1;
            }
            if ((indexLast = ((IndexedCell)flow.getLastVisibleCell()).getIndex()) >= table.getItems().size()) {
                indexLast = table.getItems().size() - 1;
            }
        } else {
            indexFirst = 0;
            indexLast = 0;
        }
        return new int[]{indexFirst, indexLast};
    }

    public static void selectNextRow(TableView tableView) {
        int selectedTableRow = tableView.getSelectionModel().getSelectedIndex();
        if (selectedTableRow < 0) {
            tableView.getSelectionModel().clearAndSelect(0);
            tableView.scrollTo(0);
        } else if (selectedTableRow >= 0 && selectedTableRow < tableView.getItems().size() - 1) {
            tableView.getSelectionModel().clearAndSelect(selectedTableRow + 1);
            tableView.scrollTo(selectedTableRow + 1);
        } else if (selectedTableRow == tableView.getItems().size() - 1) {
            tableView.getSelectionModel().clearAndSelect(0);
            tableView.scrollTo(0);
        }
    }

    public static void selectPreviousRow(TableView tableView) {
        int selectedTableRow = tableView.getSelectionModel().getSelectedIndex();
        if (selectedTableRow < 0) {
            tableView.getSelectionModel().clearAndSelect(0);
            tableView.scrollTo(0);
        } else if (selectedTableRow == 0) {
            tableView.getSelectionModel().clearAndSelect(tableView.getItems().size() - 1);
            tableView.scrollTo(tableView.getItems().size() - 1);
        } else if (selectedTableRow <= tableView.getItems().size() - 1) {
            tableView.getSelectionModel().clearAndSelect(selectedTableRow - 1);
            tableView.scrollTo(selectedTableRow - 1);
        }
    }

    public static void invertSelection_(TableView tableView) {
        for (int i = 0; i < tableView.getItems().size(); ++i) {
            if (tableView.getSelectionModel().isSelected(i)) {
                tableView.getSelectionModel().clearSelection(i);
                continue;
            }
            tableView.getSelectionModel().select(i);
        }
    }

    public static void invertSelection(TableView tableView) {
        ObservableList selArr = tableView.getSelectionModel().getSelectedIndices();
        HashSet selHash = new HashSet(selArr);
        tableView.getSelectionModel().selectAll();
        int sum = tableView.getItems().size();
        int sel = -1;
        for (int i = 0; i < sum; ++i) {
            if (selHash.contains(i)) {
                tableView.getSelectionModel().clearSelection(i);
                continue;
            }
            if (sel >= 0) continue;
            sel = i;
        }
        if (sel >= 0) {
            tableView.getSelectionModel().select(sel);
        }
    }

    public static <S> void addAutoScroll(TableView<S> view) {
        if (view == null) {
            throw new NullPointerException();
        }
        ObservableList list = view.getItems();
        list.addListener(c -> {
            c.next();
            int size = view.getItems().size();
            if (size > 0 && c.wasAdded()) {
                Object element = list.get(c.getFrom());
                view.getSelectionModel().clearSelection();
                view.scrollTo(element);
                view.getSelectionModel().select(element);
            }
        });
    }

    public static class PCellMoney<A, V>
    extends TableCell<A, V> {
        boolean showNull = true;

        public PCellMoney() {
            this.setAlignment(Pos.CENTER_RIGHT);
            this.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
        }

        public PCellMoney(boolean showNull) {
            this.showNull = showNull;
            this.setAlignment(Pos.CENTER_RIGHT);
            this.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
        }

        @Override
        protected void updateItem(V value, boolean empty) {
            super.updateItem(value, empty);
            if (empty) {
                this.setText(null);
            } else if (value.getClass().equals(Long.class)) {
                double d = ((Long)value).longValue();
                if (!this.showNull && d == 0.0) {
                    this.setText("");
                } else {
                    this.setText(currencyFormat.format(d / 100.0));
                }
            } else {
                this.setText(currencyFormat.format(value));
            }
        }
    }
}

