/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.dialogs.P2DialogFileChooser;
import de.p2tools.p2lib.tools.log.P2Log;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import javafx.application.Platform;
import javafx.beans.property.StringProperty;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;

public class P2Open {
    public static void openFile(String path) {
        P2Open.openFile(P2LibConst.actStage, path);
    }

    public static void openFile(Stage stage, String fileStr) {
        if (fileStr.isEmpty()) {
            return;
        }
        if (!new File(fileStr).exists()) {
            return;
        }
        File file = new File(fileStr);
        Thread th = new Thread(() -> {
            try {
                Desktop d;
                if (Desktop.isDesktopSupported() && (d = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN)) {
                    d.open(file);
                }
            }
            catch (Exception ex) {
                new P2Alert();
                P2Alert.showErrorAlert(stage, "Fehler beim \u00f6ffnen der Datei", "Kann die Datei nicht \u00f6ffnen!");
            }
        });
        th.setName("openFile");
        th.start();
    }

    public static void openDir(String path) {
        P2Open.openDir(P2LibConst.actStage, path, null, null);
    }

    public static void openDir(Stage primaryStage, String path) {
        P2Open.openDir(primaryStage, path, null, null);
    }

    public static void openDir(String path, StringProperty prog, ImageView getProgIcon) {
        P2Open.openDir(P2LibConst.actStage, path, prog, getProgIcon);
    }

    public static void openDir(Stage stage, String path, StringProperty prog, ImageView getProgIcon) {
        if (((String)path).isEmpty()) {
            return;
        }
        if (!((String)path).endsWith(File.separator)) {
            path = (String)path + File.separator;
        }
        File directory = new File((String)path).exists() ? new File((String)path) : new File((String)path).getParentFile();
        if (prog != null && !prog.getValueSafe().isEmpty()) {
            try {
                String program = prog.getValueSafe();
                String[] arrProgCallArray = new String[]{program, directory.getAbsolutePath()};
                Runtime.getRuntime().exec(arrProgCallArray);
            }
            catch (Exception ex) {
                Platform.runLater(() -> P2Open.afterPlay(stage, TEXT.DIR, prog, directory.getAbsolutePath()));
            }
        } else {
            Thread th = new Thread(() -> {
                try {
                    Desktop d;
                    if (Desktop.isDesktopSupported() && (d = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN)) {
                        d.open(directory);
                    }
                }
                catch (Exception ex) {
                    Platform.runLater(() -> P2Open.afterPlay(stage, TEXT.DIR, prog, directory.getAbsolutePath()));
                }
            });
            th.setName("openDir");
            th.start();
        }
    }

    public static void playStoredFilm(String file) {
        P2Open.playStoredFilm(P2LibConst.actStage, file, null, null);
    }

    public static void playStoredFilm(Stage primaryStage, String file) {
        P2Open.playStoredFilm(primaryStage, file, null, null);
    }

    public static void playStoredFilm(String file, StringProperty prog, ImageView getProgIcon) {
        P2Open.playStoredFilm(P2LibConst.actStage, file, prog, getProgIcon);
    }

    public static void playStoredFilm(Stage stage, String file, StringProperty prog, ImageView getProgIcon) {
        if (file.isEmpty()) {
            return;
        }
        File filmFile = new File(file);
        if (!filmFile.exists()) {
            new P2DialogFileChooser();
            P2DialogFileChooser.showErrorAlert("Fehler", "Kein Film", "Film existiert noch nicht!");
            return;
        }
        if (prog != null && !prog.getValueSafe().isEmpty()) {
            try {
                String program = prog.getValueSafe();
                String[] cmd = new String[]{program, filmFile.getAbsolutePath()};
                Runtime.getRuntime().exec(cmd);
            }
            catch (Exception ex) {
                Platform.runLater(() -> P2Open.afterPlay(stage, TEXT.FILM, prog, file));
            }
        } else {
            Thread th = new Thread(() -> {
                try {
                    Desktop d;
                    if (Desktop.isDesktopSupported() && (d = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN)) {
                        d.open(new File(file));
                    }
                }
                catch (Exception ex) {
                    Platform.runLater(() -> P2Open.afterPlay(stage, TEXT.FILM, prog, file));
                }
            });
            th.setName("playStoredFilm");
            th.start();
        }
    }

    public static void playStoredFilm(String[] arrProgCallArray, StringProperty prog, String file, ImageView getProgIcon) {
        P2Open.playStoredFilm(P2LibConst.actStage, arrProgCallArray, prog, file, getProgIcon);
    }

    private static void playStoredFilm(Stage stage, String[] arrProgCallArray, StringProperty prog, String file, ImageView getProgIcon) {
        if (file.isEmpty()) {
            return;
        }
        if (arrProgCallArray.length != 0) {
            try {
                Runtime.getRuntime().exec(arrProgCallArray);
            }
            catch (Exception ex) {
                Platform.runLater(() -> P2Open.afterPlay(stage, TEXT.FILM, prog, file));
            }
        } else {
            Thread th = new Thread(() -> {
                try {
                    Desktop d;
                    if (Desktop.isDesktopSupported() && (d = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN)) {
                        d.open(new File(file));
                    }
                }
                catch (Exception ex) {
                    Platform.runLater(() -> P2Open.afterPlay(stage, TEXT.FILM, prog, file));
                }
            });
            th.setName("playStoredFilm");
            th.start();
        }
    }

    public static void openURL(String url) {
        P2Open.openURL(P2LibConst.actStage, url);
    }

    public static void openURL(Stage primaryStage, String url) {
        P2Open.openURL(primaryStage, url, null);
    }

    public static void openURL(String url, StringProperty prog, ImageView getProgIcon) {
        P2Open.openURL(P2LibConst.actStage, url, prog);
    }

    public static void openURL(Stage stage, String url, StringProperty prog) {
        if (url.isEmpty()) {
            return;
        }
        if (prog != null && !prog.getValueSafe().isEmpty()) {
            try {
                String program = prog.getValueSafe();
                String[] cmd = new String[]{program, url};
                Runtime.getRuntime().exec(cmd);
            }
            catch (Exception ex) {
                P2Open.afterPlay(stage, TEXT.URL, prog, url);
            }
        } else {
            Thread th = new Thread(() -> {
                try {
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        Desktop.getDesktop().browse(new URI(url));
                    } else {
                        Runtime runtime = Runtime.getRuntime();
                        runtime.exec("xdg-open " + url);
                    }
                }
                catch (Exception ex) {
                    Platform.runLater(() -> P2Open.afterPlay(stage, TEXT.URL, prog, url));
                }
            });
            th.setName("openURL");
            th.start();
        }
    }

    public static void openExternProgram(Stage stage, StringProperty prog) {
        if (prog != null && !prog.getValueSafe().isEmpty()) {
            try {
                String program = prog.getValueSafe();
                Runtime.getRuntime().exec(program);
            }
            catch (Exception ex) {
                Platform.runLater(() -> P2Open.afterPlay(stage, TEXT.EXTERN, prog, ""));
            }
        }
    }

    private static void afterPlay(Stage stage, TEXT t, StringProperty stringProperty, String fileUrl) {
        boolean ok;
        String header;
        String title;
        if (stringProperty == null) {
            P2Open.afterPlay(t);
            return;
        }
        String program = "";
        String cont = switch (t) {
            default -> {
                title = "Kein Videoplayer";
                header = "Videoplayer ausw\u00e4hlen";
                yield "Der Videoplayer \"" + stringProperty.getValueSafe() + "\" zum Abspielen wird nicht gefunden.";
            }
            case TEXT.DIR -> {
                title = "Kein Dateimanager";
                header = "Dateimanager ausw\u00e4hlen";
                yield "Der Dateimanager \"" + stringProperty.getValueSafe() + "\" zum Anzeigen des Speicherordners wird nicht gefunden.";
            }
            case TEXT.URL -> {
                title = "Kein Browser";
                header = "Browser ausw\u00e4hlen";
                yield "Der Browser \"" + stringProperty.getValueSafe() + "\" zum Anzeigen der URL wird nicht gefunden.";
            }
            case TEXT.EXTERN -> {
                title = "Kein Programm";
                header = "Externes Programm ausw\u00e4hlen";
                yield "Das externe Programm \"" + stringProperty.getValueSafe() + "\" wird nicht gefunden.";
            }
        };
        try {
            program = P2DialogFileChooser.showFileChooser(stage, title, header, cont, false);
            if (!program.isEmpty()) {
                String[] cmd = new String[]{program, fileUrl};
                Runtime.getRuntime().exec(cmd);
                stringProperty.set(program);
                ok = true;
            } else {
                ok = true;
            }
        }
        catch (Exception eex) {
            ok = false;
            P2Log.errorLog(912030654, eex, new String[]{"Kann nicht \u00f6ffnen,", "Programm: " + program, "File/Url: " + fileUrl});
        }
        if (!ok) {
            stringProperty.set("");
            new P2Alert();
            P2Alert.showErrorAlert("Fehler beim \u00f6ffnen des Programms", "Kann das Programm nicht \u00f6ffnen!");
        }
    }

    private static void afterPlay(TEXT t) {
        String header;
        P2Alert.showErrorAlert(header, switch (t) {
            default -> {
                header = "Kein Videoplayer";
                yield "Ein Videoplayer zum Abspielen wird nicht gefunden.";
            }
            case TEXT.DIR -> {
                header = "Kein Dateimanager";
                yield "Der Dateimanager zum Anzeigen des Speicherordners wird nicht gefunden.";
            }
            case TEXT.URL -> {
                header = "Kein Browser";
                yield "Der Browser zum Anzeigen der URL wird nicht gefunden.";
            }
            case TEXT.EXTERN -> {
                header = "Kein externes Programm";
                yield "Das externe Programm das gestartet werden soll, wird nicht gefunden";
            }
        });
    }

    static enum TEXT {
        FILM,
        DIR,
        URL,
        EXTERN;

    }
}

