/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import de.p2tools.p2lib.guitools.P2Styles;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javafx.scene.Node;
import javafx.util.converter.NumberStringConverter;

public class P2NumberStringConverter
extends NumberStringConverter {
    private final Locale locale = Locale.GERMAN;
    private NumberFormat numberFormat = NumberFormat.getNumberInstance(this.locale);
    private final Node node;
    private boolean stateLabel = false;

    public P2NumberStringConverter(Node node) {
        this.node = node;
    }

    public P2NumberStringConverter(Node node, boolean stateLabel) {
        this.stateLabel = stateLabel;
        this.node = node;
        this.setStateLabel();
    }

    private void setStateLabel() {
        if (this.stateLabel) {
            this.node.setStyle(P2Styles.PTEXTFIELD_LABEL);
        }
    }

    @Override
    public Number fromString(String value) {
        return this.check(value);
    }

    public Number check(String value) {
        Number ret = 0;
        try {
            this.setNodeStyle(this.stateLabel ? P2Styles.PTEXTFIELD_LABEL : "");
            if (value == null) {
                return null;
            }
            if ((value = value.trim()).length() < 1) {
                this.setNodeStyle("");
                return null;
            }
            ret = this.numberFormat.parse(value);
            String s = this.numberFormat.format(ret);
            if (!s.equals(value) && !value.equals(String.valueOf(ret))) {
                this.setNodeStyle(this.stateLabel ? P2Styles.PTEXTFIELD_LABEL_ERROR : P2Styles.PTEXTFIELD_ERROR);
            }
        }
        catch (ParseException ex) {
            this.setNodeStyle(this.stateLabel ? P2Styles.PTEXTFIELD_LABEL_ERROR : P2Styles.PTEXTFIELD_ERROR);
        }
        return ret;
    }

    private void setNodeStyle(String style) {
        if (this.node == null) {
            return;
        }
        this.node.setStyle(style);
    }
}

