/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import java.util.ArrayList;
import java.util.Arrays;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.MenuButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class P2MenuButton
extends MenuButton {
    private final StringProperty filterProperty;
    private final ObservableList<String> allButtonList;
    private final ArrayList<MenuItemClass> menuItemsList = new ArrayList();

    public P2MenuButton(StringProperty filterProperty, ObservableList<String> allButtonList) {
        this.filterProperty = filterProperty;
        this.allButtonList = allButtonList;
        this.initMenuButton();
    }

    public P2MenuButton(StringProperty filterProperty, ObservableList<String> allButtonList, boolean minWidth) {
        this.filterProperty = filterProperty;
        this.allButtonList = allButtonList;
        this.initMenuButton();
        if (minWidth) {
            this.setMaxWidth(-1.0);
            this.setMinWidth(200.0);
        }
    }

    private void initMenuButton() {
        this.getStyleClass().add("cbo-menu");
        this.setMaxWidth(Double.MAX_VALUE);
        this.updateMenuButton();
        this.filterProperty.addListener((observable2, oldValue, newValue) -> this.updateMenuButton());
        this.allButtonList.addListener(c -> this.updateMenuButton());
        this.textProperty().bindBidirectional(this.filterProperty);
    }

    private void updateMenuButton() {
        this.getItems().clear();
        this.menuItemsList.clear();
        ArrayList filterList = new ArrayList();
        ArrayList<String> tmpList = new ArrayList<String>();
        String channelFilter = (String)this.filterProperty.get();
        if (channelFilter != null) {
            if (channelFilter.contains(",")) {
                tmpList.addAll(Arrays.asList(channelFilter.toLowerCase().split(",")));
            } else {
                tmpList.add(channelFilter.toLowerCase());
            }
            tmpList.forEach(s -> filterList.add(s.trim()));
        }
        CheckBox miCheckAll = new CheckBox();
        miCheckAll.setVisible(false);
        Button btnClear = new Button("Auswahl l\u00f6schen");
        btnClear.getStyleClass().add("cbo-menu-button");
        btnClear.setMaxWidth(Double.MAX_VALUE);
        btnClear.minWidthProperty().bind(this.widthProperty().add(-50));
        btnClear.setOnAction(e -> {
            this.clearChannelMenuText();
            this.hide();
        });
        HBox hBoxAll = new HBox(5.0);
        hBoxAll.setAlignment(Pos.CENTER_LEFT);
        hBoxAll.getChildren().addAll((Node[])new Node[]{miCheckAll, btnClear});
        CustomMenuItem cmiAll = new CustomMenuItem(hBoxAll);
        cmiAll.getStyleClass().add("cbo-menu-item");
        this.getItems().add(cmiAll);
        for (String s2 : this.allButtonList) {
            if (s2.trim().isEmpty()) continue;
            CheckBox miCheck = new CheckBox();
            if (filterList.contains(s2.trim().toLowerCase())) {
                miCheck.setSelected(true);
            }
            miCheck.setOnAction(a -> this.setMenuText());
            MenuItemClass menuItemClass = new MenuItemClass(s2, miCheck);
            this.menuItemsList.add(menuItemClass);
            Button btnChannel = new Button(s2);
            btnChannel.getStyleClass().add("cbo-menu-button");
            btnChannel.setMaxWidth(Double.MAX_VALUE);
            btnChannel.minWidthProperty().bind(this.widthProperty().add(-50));
            btnChannel.setOnAction(e -> {
                this.setChannelCheckBoxAndMenuText(menuItemClass);
                this.hide();
            });
            HBox hBox = new HBox(5.0);
            hBox.prefWidthProperty().bind(hBoxAll.widthProperty());
            hBox.setAlignment(Pos.CENTER_LEFT);
            HBox.setHgrow(btnChannel, Priority.ALWAYS);
            hBox.getChildren().addAll((Node[])new Node[]{miCheck, btnChannel});
            CustomMenuItem cmi = new CustomMenuItem(hBox);
            cmi.getStyleClass().add("cbo-menu-item");
            this.getItems().add(cmi);
            cmi.setOnAction(e -> this.setChannelCheckBoxAndMenuText(menuItemClass));
        }
    }

    private void setChannelCheckBoxAndMenuText(MenuItemClass cmi) {
        for (MenuItemClass cm : this.menuItemsList) {
            cm.getCheckBox().setSelected(false);
        }
        cmi.getCheckBox().setSelected(true);
        this.setMenuText();
    }

    private void clearChannelMenuText() {
        for (MenuItemClass cmi : this.menuItemsList) {
            cmi.getCheckBox().setSelected(false);
        }
        this.setText("");
        this.doAfterSelction("");
    }

    private void setMenuText() {
        StringBuilder text = new StringBuilder();
        for (MenuItemClass cmi : this.menuItemsList) {
            if (!cmi.getCheckBox().isSelected()) continue;
            text.append(text.isEmpty() ? "" : ", ").append(cmi.getText());
        }
        this.setText(text.toString());
        this.doAfterSelction(text.toString());
    }

    public void doAfterSelction(String text) {
    }

    private static class MenuItemClass {
        private final String text;
        private final CheckBox checkBox;

        MenuItemClass(String text, CheckBox checkbox) {
            this.text = text;
            this.checkBox = checkbox;
        }

        public String getText() {
            return this.text;
        }

        public CheckBox getCheckBox() {
            return this.checkBox;
        }
    }
}

