/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.configfile;

import de.p2tools.p2lib.configfile.ConfigBackupFile;
import de.p2tools.p2lib.configfile.ConfigFile;
import de.p2tools.p2lib.configfile.ConfigRead;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.net.P2UrlConnectionFactory;
import de.p2tools.p2lib.tools.net.PUrlTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ConfigReadFile {
    private ConfigReadFile() {
    }

    public static boolean readConfig(ConfigFile configFile) {
        if (ConfigReadFile.readConfiguration(configFile)) {
            P2Log.sysLog("Config laden OK, geladen von: " + configFile.getFilePath());
            return true;
        }
        if (!configFile.isBackup()) {
            P2Log.sysLog("Config laden hat nicht geklappt: " + configFile.getFilePath());
            P2Log.sysLog("Es soll kein Backup geladen werden." + configFile.getFilePath());
            return false;
        }
        ArrayList<Path> pathList = new ConfigBackupFile(Path.of(configFile.getFilePath(), new String[0])).loadBackup(configFile.getBackupHeader(), configFile.getBackupText());
        if (pathList == null) {
            P2Log.sysLog("Es gibt keine Backups.");
            return false;
        }
        for (Path p : pathList) {
            configFile.clearConfigFile();
            configFile.setFilePath(p.toString());
            if (!ConfigReadFile.readConfiguration(configFile)) continue;
            P2Log.sysLog("Config aus Backup geladen: " + p.toFile().getAbsolutePath());
            return true;
        }
        P2Log.sysLog("Config-Backup laden hat nicht geklappt: " + configFile.getFilePath());
        return false;
    }

    private static boolean readConfiguration(ConfigFile configFile) {
        boolean ret;
        P2Duration.counterStart("readConfiguration");
        if (configFile.getIsr() != null) {
            try {
                ret = new ConfigRead(configFile).read(configFile.getIsr());
            }
            catch (Exception ex) {
                P2Log.errorLog(956301247, ex);
                ret = false;
            }
        } else if (PUrlTools.isUrl(configFile.getFilePath())) {
            HttpURLConnection conn = null;
            try {
                conn = P2UrlConnectionFactory.getUrlConnection(configFile.getFilePath());
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
            }
            catch (MalformedURLException ex) {
                P2Log.errorLog(965312078, ex);
            }
            catch (Exception ex) {
                P2Log.errorLog(159487302, ex);
            }
            try (InputStream is = conn.getInputStream();
                 InputStreamReader in = new InputStreamReader(is, StandardCharsets.UTF_8);){
                ret = new ConfigRead(configFile).read(in);
            }
            catch (Exception ex) {
                ret = false;
                P2Log.errorLog(825414789, ex);
            }
        } else if (configFile.getFilePath().endsWith(".zip")) {
            if (!Files.exists(Path.of(configFile.getFilePath(), new String[0]), new LinkOption[0])) {
                return false;
            }
            try {
                ZipFile zipFile = new ZipFile(configFile.getFilePath());
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                ret = false;
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    InputStream stream = zipFile.getInputStream(entry);
                    InputStreamReader in = new InputStreamReader(stream, StandardCharsets.UTF_8);
                    ret = new ConfigRead(configFile).read(in);
                    if (ret) continue;
                }
            }
            catch (IOException ex) {
                P2Log.errorLog(956301247, ex);
                ret = false;
            }
        } else {
            if (!Files.exists(Path.of(configFile.getFilePath(), new String[0]), new LinkOption[0])) {
                return false;
            }
            try (InputStream is = Files.newInputStream(Path.of(configFile.getFilePath(), new String[0]), new OpenOption[0]);
                 InputStreamReader in = new InputStreamReader(is, StandardCharsets.UTF_8);){
                ret = new ConfigRead(configFile).read(in);
            }
            catch (Exception ex) {
                ret = false;
                P2Log.errorLog(454102598, ex);
            }
        }
        P2Duration.counterStop("readConfiguration");
        return ret;
    }
}

