/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.configfile;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.dialogs.P2DialogFileChooser;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Calendar;

class ConfigBackupFile {
    public static final int MAX_COPY_BACKUP_FILE = 5;
    private static boolean alreadyMadeBackup = false;
    private static final String CONFIG_FILE_COPY_ADDON = "_copy_";
    private final String backupFileName;
    private final Path filePath;

    ConfigBackupFile(Path filePath) {
        this.filePath = filePath;
        this.backupFileName = filePath.getFileName().toString() + CONFIG_FILE_COPY_ADDON;
    }

    void backupConfigFile() {
        if (alreadyMadeBackup) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("------------------------------------------------------------");
        list.add("BackupConfigFile sichern");
        try {
            long createTime = -1L;
            Path confFileCopy = this.filePath.getParent().resolve(this.backupFileName + "1");
            if (Files.exists(confFileCopy, new LinkOption[0])) {
                BasicFileAttributes attrs = Files.readAttributes(confFileCopy, BasicFileAttributes.class, new LinkOption[0]);
                FileTime d = attrs.lastModifiedTime();
                createTime = d.toMillis();
            }
            if (createTime == -1L || createTime < this.getToday_00_00()) {
                for (int i = 5; i > 1; --i) {
                    confFileCopy = this.filePath.getParent().resolve(this.backupFileName + (i - 1));
                    Path confFileCopy_2 = this.filePath.getParent().resolve(this.backupFileName + i);
                    if (!Files.exists(confFileCopy, new LinkOption[0])) continue;
                    Files.move(confFileCopy, confFileCopy_2, StandardCopyOption.REPLACE_EXISTING);
                }
                if (Files.exists(this.filePath, new LinkOption[0])) {
                    Files.move(this.filePath, this.filePath.getParent().resolve(this.backupFileName + "1"), StandardCopyOption.REPLACE_EXISTING);
                }
                list.add("BackupConfigFile wurde gesichert: " + this.backupFileName + "1");
            } else {
                list.add("BackupConfigFile wurde heute schon gesichert");
            }
        }
        catch (IOException e) {
            list.add("Die Einstellungen konnten nicht komplett gesichert werden!");
            P2Log.errorLog(795623147, e);
        }
        alreadyMadeBackup = true;
        list.add("------------------------------------------------------------");
        P2Log.sysLog(list);
    }

    ArrayList<Path> loadBackup(String header, String text) {
        ArrayList<Path> pathList = new ArrayList<Path>();
        this.getXmlCopyFilePath(pathList);
        if (pathList.isEmpty()) {
            P2Log.sysLog("Es gibt kein Backup");
            return null;
        }
        P2Log.sysLog("Es gibt ein Backup");
        new P2DialogFileChooser();
        if (P2Alert.BUTTON.YES != P2DialogFileChooser.showAlert_yes_no(null, "Gesicherte Einstellungen laden?", (String)(header.isEmpty() ? "Die Einstellungen sind besch\u00e4digt" + P2LibConst.LINE_SEPARATOR + "und k\u00f6nnen nicht geladen werden." : header), (String)(text.isEmpty() ? "Soll versucht werden, mit gesicherten" + P2LibConst.LINE_SEPARATOR + "Einstellungen zu starten?" + P2LibConst.LINE_SEPARATORx2 + "(ansonsten startet das Programm mit" + P2LibConst.LINE_SEPARATOR + "Standardeinstellungen)" : text))) {
            P2Log.sysLog("User will kein Backup laden.");
            return null;
        }
        return pathList;
    }

    private void getXmlCopyFilePath(ArrayList<Path> xmlFilePath) {
        for (int i = 1; i <= 5; ++i) {
            Path path = this.filePath.getParent().resolve(this.backupFileName + i);
            if (!Files.exists(path, new LinkOption[0])) continue;
            xmlFilePath.add(path);
        }
    }

    private long getToday_00_00() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }
}

