/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.checkforactinfos;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.checkforactinfos.FoundDownloadDialogController;
import de.p2tools.p2lib.checkforactinfos.FoundHttpDownload;
import de.p2tools.p2lib.checkforactinfos.FoundSearchDataDTO;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.net.P2UrlConnectionFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class FoundFactory {
    public static void downloadFile(FoundSearchDataDTO foundSearchDataDTO, String url) {
        FoundDownloadDialogController downloadDialogController = new FoundDownloadDialogController(foundSearchDataDTO, url, foundSearchDataDTO.downloadDirProperty());
        if (downloadDialogController.getOk()) {
            P2Log.sysLog("Download wird gestartet");
            FoundHttpDownload download = new FoundHttpDownload(foundSearchDataDTO.getStage(), url, downloadDialogController.getDestPath(), downloadDialogController.getDestName());
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            download.start();
        } else {
            P2Log.sysLog("Download wird nicht gestartet");
        }
    }

    public static boolean isNewFound(String old, String newValue) {
        return FoundFactory.isNewFound(old, newValue, null);
    }

    public static boolean isNewFound(String old, String newValue, ArrayList<String> log) {
        if (newValue.compareTo(old) <= 0) {
            if (log != null) {
                log.add("  old: " + old + "  isNewFound: " + newValue);
                log.add("  -> gibt nichts oder schon mal angezeigt");
            }
            return false;
        }
        if (log != null) {
            log.add("  old: " + old + "  isNewFound: " + newValue);
        }
        return true;
    }

    public static String getInfoFile(String url) {
        Object ret = "";
        try (InputStreamReader in = new InputStreamReader(FoundFactory.connectToServer(url), StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(in);){
            String strLine;
            while ((strLine = br.readLine()) != null) {
                ret = (String)ret + P2LibConst.LINE_SEPARATOR + strLine;
            }
        }
        catch (IOException ex) {
            P2Log.errorLog(951254670, ex);
        }
        return ret;
    }

    public static InputStream connectToServer(String searchUrl) throws IOException {
        int TIMEOUT = 10000;
        HttpURLConnection conn = P2UrlConnectionFactory.getUrlConnection(searchUrl);
        conn.setRequestProperty("User-Agent", P2LibConst.userAgent);
        conn.setReadTimeout(10000);
        conn.setConnectTimeout(10000);
        return conn.getInputStream();
    }
}

