/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.checkforactinfos;

import de.p2tools.p2lib.checkforactinfos.FoundFactory;
import de.p2tools.p2lib.checkforactinfos.FoundFile;
import de.p2tools.p2lib.checkforactinfos.FoundSearchDataDTO;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;

public class FoundAllFiles {
    static LocalDate maxFoundDate = LocalDate.EPOCH;

    private FoundAllFiles() {
    }

    static void found(FoundSearchDataDTO foundSearchDataDTO) {
        maxFoundDate = LocalDate.EPOCH;
        try (InputStreamReader in = new InputStreamReader(FoundFactory.connectToServer(foundSearchDataDTO.getSearchUrlDownload()), StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(in);){
            String strLine;
            foundSearchDataDTO.setFoundNewInfo(false);
            foundSearchDataDTO.setFoundNewVersion(false);
            foundSearchDataDTO.setFoundNewBeta(false);
            foundSearchDataDTO.setFoundNewDaily(false);
            while ((strLine = br.readLine()) != null) {
                if (!strLine.contains("<a href=\"/download/") || !strLine.contains(foundSearchDataDTO.getProgName())) continue;
                try {
                    if (strLine.contains("info")) {
                        FoundAllFiles.addInfo(foundSearchDataDTO, strLine);
                        continue;
                    }
                    if (strLine.contains("act")) {
                        FoundAllFiles.addAct(foundSearchDataDTO, strLine);
                        continue;
                    }
                    if (strLine.contains("beta")) {
                        FoundAllFiles.addBetaDaily(true, foundSearchDataDTO, strLine);
                        continue;
                    }
                    if (!strLine.contains("daily")) continue;
                    FoundAllFiles.addBetaDaily(false, foundSearchDataDTO, strLine);
                }
                catch (Exception ex) {
                    P2Log.errorLog(102548790, ex);
                }
            }
        }
        catch (IOException ex) {
            P2Log.errorLog(201312587, ex);
        }
    }

    private static void addInfo(FoundSearchDataDTO foundSearchDataDTO, String strLine) {
        int idx1 = strLine.indexOf("href=\"");
        int idx2 = strLine.indexOf("\">");
        int idx3 = strLine.indexOf("\">");
        int idx4 = strLine.indexOf("</a>");
        if (idx1 >= 0 && idx2 >= 0 && idx3 >= 0 && idx4 >= 0) {
            FoundFile foundFile = new FoundFile();
            foundFile.setFileUrl(foundSearchDataDTO.getSearchUrl() + strLine.substring(idx1 += "href=\"".length(), idx2));
            String fileName = strLine.substring(idx3 += "\">".length(), idx4);
            foundFile.setFileName(fileName);
            foundFile.setFileDate(fileName.substring(fileName.indexOf("__") + "__".length(), fileName.lastIndexOf(".")));
            if (FoundAllFiles.checkInfo(foundSearchDataDTO, foundFile)) {
                P2Log.debugLog("Infofile gefunden: " + foundFile.getFileName() + "  --  " + foundFile.getFileUrl());
                foundSearchDataDTO.setFoundNewInfo(true);
                foundSearchDataDTO.setNewInfoDate(foundFile.getFileDate());
                foundFile.setFileText(FoundFactory.getInfoFile(foundFile.getFileUrl()));
                foundSearchDataDTO.getFoundFileListInfo().add(foundFile);
            }
            FoundAllFiles.setLastFoundDate(foundSearchDataDTO, foundFile);
        }
    }

    private static void addAct(FoundSearchDataDTO foundSearchDataDTO, String strLine) {
        int idx1 = strLine.indexOf("href=\"");
        int idx2 = strLine.indexOf("\">");
        int idx3 = strLine.indexOf("\">");
        int idx4 = strLine.indexOf("</a>");
        if (idx1 >= 0 && idx2 >= 0 && idx3 >= 0 && idx4 >= 0) {
            FoundFile foundFile = new FoundFile();
            foundFile.setFileUrl(foundSearchDataDTO.getSearchUrl() + strLine.substring(idx1 += "href=\"".length(), idx2));
            String fileName = strLine.substring(idx3 += "\">".length(), idx4);
            foundFile.setFileName(fileName);
            if (fileName.contains("-") && fileName.contains("__")) {
                foundFile.setFileVersion(fileName.substring(fileName.indexOf("-") + "-".length(), fileName.indexOf("__")));
            }
            if (fileName.contains("__")) {
                foundFile.setFileDate(fileName.substring(fileName.lastIndexOf("__") + "__".length(), fileName.lastIndexOf(".")));
            }
            if (fileName.endsWith(".txt")) {
                P2Log.debugLog("Infofile laden: " + foundFile.getFileName() + "  --  " + foundFile.getFileUrl());
                foundSearchDataDTO.setNewVersionText(FoundFactory.getInfoFile(foundFile.getFileUrl()));
            } else {
                if (FoundAllFiles.checkFile(foundSearchDataDTO, foundFile)) {
                    P2Log.debugLog("Act gefunden: " + foundFile.getFileName() + "  --  " + foundFile.getFileUrl());
                    foundSearchDataDTO.setNewVersionNo(foundFile.getFileVersion());
                    foundSearchDataDTO.setFoundNewVersion(true);
                    foundSearchDataDTO.setNewVersionDate(foundFile.getFileDate());
                    foundSearchDataDTO.getFoundFileListAct().add(foundFile);
                }
                FoundAllFiles.setLastFoundDate(foundSearchDataDTO, foundFile);
            }
        }
    }

    private static void addBetaDaily(boolean beta, FoundSearchDataDTO foundSearchDataDTO, String strLine) {
        int idx1 = strLine.indexOf("href=\"");
        int idx2 = strLine.indexOf("\">");
        int idx3 = strLine.indexOf("\">");
        int idx4 = strLine.indexOf("</a>");
        if (idx1 >= 0 && idx2 >= 0 && idx3 >= 0 && idx4 >= 0) {
            FoundFile foundFile = new FoundFile();
            foundFile.setFileUrl(foundSearchDataDTO.getSearchUrl() + strLine.substring(idx1 += "href=\"".length(), idx2));
            String fileName = strLine.substring(idx3 += "\">".length(), idx4);
            foundFile.setFileName(fileName);
            foundFile.setFileVersion(fileName.substring(fileName.indexOf("-") + "-".length(), fileName.lastIndexOf("-")));
            String buildNo = fileName.substring(fileName.lastIndexOf("-") + "-".length(), fileName.lastIndexOf("__"));
            if (buildNo.contains("__")) {
                buildNo = buildNo.substring(0, buildNo.lastIndexOf("__"));
            }
            foundFile.setFileBuildNo(buildNo);
            foundFile.setFileDate(fileName.substring(fileName.lastIndexOf("__") + "__".length(), fileName.lastIndexOf(".")));
            if (fileName.endsWith(".txt")) {
                if (beta) {
                    foundSearchDataDTO.setNewBetaText(FoundFactory.getInfoFile(foundFile.getFileUrl()));
                } else {
                    foundSearchDataDTO.setNewDailyText(FoundFactory.getInfoFile(foundFile.getFileUrl()));
                }
            } else {
                if (FoundAllFiles.checkFile(foundSearchDataDTO, foundFile)) {
                    if (beta) {
                        P2Log.debugLog("Beta gefunden: " + foundFile.getFileName() + "  --  " + foundFile.getFileUrl());
                        foundSearchDataDTO.setFoundNewBeta(true);
                        foundSearchDataDTO.setNewBetaVersion(foundFile.getFileVersion());
                        foundSearchDataDTO.setNewBetaBuildNo(foundFile.getFileBuildNo());
                        foundSearchDataDTO.setNewBetaDate(foundFile.getFileDate());
                        foundSearchDataDTO.getFoundFileListBeta().add(foundFile);
                    } else {
                        P2Log.debugLog("Daily gefunden: " + foundFile.getFileName() + "  --  " + foundFile.getFileUrl());
                        foundSearchDataDTO.setFoundNewDaily(true);
                        foundSearchDataDTO.setNewDailyVersion(foundFile.getFileVersion());
                        foundSearchDataDTO.setNewDailyBuild(foundFile.getFileBuildNo());
                        foundSearchDataDTO.setNewDailyDate(foundFile.getFileDate());
                        foundSearchDataDTO.getFoundFileListDaily().add(foundFile);
                    }
                }
                FoundAllFiles.setLastFoundDate(foundSearchDataDTO, foundFile);
            }
        }
    }

    private static void setLastFoundDate(FoundSearchDataDTO foundSearchDataDTO, FoundFile foundFile) {
        LocalDate ld = P2LDateFactory.fromStringR(foundFile.getFileDate());
        if (ld.isAfter(maxFoundDate)) {
            maxFoundDate = ld;
        }
    }

    private static boolean checkInfo(FoundSearchDataDTO foundSearchDataDTO, FoundFile foundFile) {
        if (foundSearchDataDTO.isShowAllDownloads()) {
            return true;
        }
        return foundSearchDataDTO.isShowDialogAlways() || !foundSearchDataDTO.isShowDialogAlways() && FoundFactory.isNewFound(foundSearchDataDTO.getLastFoundDate(), foundFile.getFileDate());
    }

    private static boolean checkFile(FoundSearchDataDTO foundSearchDataDTO, FoundFile foundFile) {
        if (foundSearchDataDTO.isShowAllDownloads()) {
            return true;
        }
        boolean ret = foundSearchDataDTO.isShowDialogAlways() && FoundFactory.isNewFound(foundSearchDataDTO.getProgBuildDate(), foundFile.getFileDate()) || !foundSearchDataDTO.isShowDialogAlways() && FoundFactory.isNewFound(foundSearchDataDTO.getLastFoundDate(), foundFile.getFileDate());
        return ret;
    }
}

