/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.tools;

import de.p2tools.p2lib.tools.log.P2Log;
import java.util.concurrent.Semaphore;
import javafx.beans.property.IntegerProperty;

public class MLBandwidthTokenBucket {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private final Semaphore bucketSize = new Semaphore(0, false);
    public static final int BANDWIDTH_MAX_RED_KBYTE = 500;
    public static final int BANDWIDTH_MAX_BYTE = 1000000;
    public static final int BANDWIDTH_MAX_KBYTE = 1000;
    private volatile int bucketCapacity = 500000;
    private MVBandwidthTokenBucketFillerThread fillerThread = null;
    IntegerProperty bandwidthValue;

    public MLBandwidthTokenBucket(IntegerProperty bandwidthValue) {
        this.bandwidthValue = bandwidthValue;
        this.setBucketCapacity(this.getBandwidth());
        this.bandwidthValue.addListener(l -> {
            P2Log.sysLog("change bucketCapacity: " + this.getBandwidth() + " bytesPerSecond");
            this.setBucketCapacity(this.getBandwidth());
        });
    }

    public synchronized void ensureBucketThreadIsRunning() {
        if (this.fillerThread == null) {
            this.fillerThread = new MVBandwidthTokenBucketFillerThread();
            this.fillerThread.start();
        }
    }

    public void takeBlocking(int howMany) {
        if (this.getBucketCapacity() < 1000000) {
            try {
                this.bucketSize.acquire(howMany);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void takeBlocking() {
        this.takeBlocking(1);
    }

    public synchronized int getBucketCapacity() {
        return this.bucketCapacity;
    }

    private void terminateFillerThread() {
        if (this.fillerThread != null) {
            this.fillerThread.interrupt();
            this.fillerThread = null;
        }
    }

    public synchronized void setBucketCapacity(int bucketCapacity) {
        this.bucketCapacity = bucketCapacity;
        if (bucketCapacity == 1000000) {
            this.terminateFillerThread();
            while (this.bucketSize.hasQueuedThreads()) {
                this.bucketSize.release();
            }
            this.bucketSize.drainPermits();
        } else {
            this.terminateFillerThread();
            this.bucketSize.drainPermits();
            this.ensureBucketThreadIsRunning();
        }
    }

    private int getBandwidth() {
        int bytesPerSecond;
        try {
            int maxKBytePerSec = this.bandwidthValue.get();
            bytesPerSecond = maxKBytePerSec * 1000;
        }
        catch (Exception ex) {
            P2Log.errorLog(612547803, ex, "reset Bandwidth");
            bytesPerSecond = 1000000;
            this.bandwidthValue.set(1000);
        }
        return bytesPerSecond;
    }

    private class MVBandwidthTokenBucketFillerThread
    extends Thread {
        public MVBandwidthTokenBucketFillerThread() {
            this.setName("MLBandwidthTokenBucket Filler Thread");
        }

        @Override
        public void run() {
            try {
                int bucketCapacity;
                while (!this.isInterrupted() && (bucketCapacity = MLBandwidthTokenBucket.this.getBucketCapacity()) != 1000000) {
                    int releaseCount = bucketCapacity / 2 - MLBandwidthTokenBucket.this.bucketSize.availablePermits();
                    if (releaseCount > 0) {
                        MLBandwidthTokenBucket.this.bucketSize.release(releaseCount);
                    }
                    MVBandwidthTokenBucketFillerThread.sleep(500L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

