/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.tools.table;

import de.p2tools.p2lib.tools.file.P2FileSize;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.gui.tools.table.PTable;
import de.p2tools.p2podder.gui.tools.table.Table;
import de.p2tools.p2podder.gui.tools.table.TableEpisodeFactory;
import java.time.LocalDate;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;

public class TableSmallEpisode
extends PTable<Episode> {
    private final ProgData progData;

    public TableSmallEpisode(Table.TABLE_ENUM table_enum, ProgData progData) {
        super(table_enum);
        this.table_enum = table_enum;
        this.progData = progData;
        this.initFileRunnerColumn();
    }

    @Override
    public Table.TABLE_ENUM getETable() {
        return this.table_enum;
    }

    public void resetTable() {
        this.initFileRunnerColumn();
        Table.resetTable(this);
    }

    private void initFileRunnerColumn() {
        this.getColumns().clear();
        this.setTableMenuButtonVisible(true);
        this.setEditable(false);
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        ProgConfig.SYSTEM_SMALL_BUTTON_TABLE_ROW.addListener((observableValue, s, t1) -> this.refresh());
        TableColumn<Episode, Integer> noColumn = new TableColumn<Episode, Integer>("Nr");
        noColumn.setCellValueFactory(new PropertyValueFactory("no"));
        noColumn.getStyleClass().add("alignCenterLeft");
        TableEpisodeFactory.columnFactoryIntegerMax(noColumn);
        TableColumn<Episode, String> podcastNameColumn = new TableColumn<Episode, String>("Podcast");
        podcastNameColumn.setCellValueFactory(new PropertyValueFactory("podcastName"));
        podcastNameColumn.getStyleClass().add("alignCenterLeft");
        TableEpisodeFactory.columnFactoryString(podcastNameColumn);
        TableColumn<Episode, String> titleColumn = new TableColumn<Episode, String>("Titel");
        titleColumn.setCellValueFactory(new PropertyValueFactory("episodeTitle"));
        titleColumn.getStyleClass().add("alignCenterLeft");
        TableEpisodeFactory.columnFactoryString(titleColumn);
        TableColumn<Episode, String> genreColumn = new TableColumn<Episode, String>("Genre");
        genreColumn.setCellValueFactory(new PropertyValueFactory("genre"));
        genreColumn.getStyleClass().add("alignCenterLeft");
        TableEpisodeFactory.columnFactoryString(genreColumn);
        TableColumn<Episode, String> startColumn = new TableColumn<Episode, String>("");
        startColumn.getStyleClass().add("alignCenter");
        TableEpisodeFactory.columnFactoryButton(startColumn);
        TableColumn<Episode, LocalDate> dateColumn = new TableColumn<Episode, LocalDate>("Datum");
        dateColumn.setCellValueFactory(new PropertyValueFactory("pubDate"));
        dateColumn.getStyleClass().add("alignCenter");
        TableEpisodeFactory.columnFactoryLocalDate(dateColumn);
        TableColumn<Episode, Integer> durationColumn = new TableColumn<Episode, Integer>("Dauer");
        durationColumn.setCellValueFactory(new PropertyValueFactory("durationInt"));
        durationColumn.getStyleClass().add("alignCenter");
        TableEpisodeFactory.columnFactoryDuration(durationColumn);
        TableColumn<Episode, P2FileSize> sizeColumn = new TableColumn<Episode, P2FileSize>("Gr\u00f6\u00dfe [MB]");
        sizeColumn.setCellValueFactory(new PropertyValueFactory("pFileSize"));
        sizeColumn.getStyleClass().add("alignCenter");
        TableEpisodeFactory.columnFactoryP2FileSize(sizeColumn);
        TableColumn<Episode, String> fileColumn = new TableColumn<Episode, String>("Dateiname");
        fileColumn.setCellValueFactory(new PropertyValueFactory("fileName"));
        fileColumn.getStyleClass().add("alignCenterLeft");
        TableEpisodeFactory.columnFactoryString(fileColumn);
        TableColumn<Episode, String> pathColumn = new TableColumn<Episode, String>("Pfad");
        pathColumn.setCellValueFactory(new PropertyValueFactory("filePath"));
        pathColumn.getStyleClass().add("alignCenterLeft");
        TableEpisodeFactory.columnFactoryString(pathColumn);
        noColumn.setPrefWidth(50.0);
        podcastNameColumn.setPrefWidth(180.0);
        titleColumn.setPrefWidth(180.0);
        genreColumn.setPrefWidth(100.0);
        dateColumn.setPrefWidth(100.0);
        sizeColumn.setPrefWidth(120.0);
        fileColumn.setPrefWidth(200.0);
        pathColumn.setPrefWidth(350.0);
        this.getColumns().addAll(noColumn, podcastNameColumn, titleColumn, genreColumn, startColumn, dateColumn, durationColumn, sizeColumn, fileColumn, pathColumn);
    }
}

