/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.tools.table;

import de.p2tools.p2podder.controller.config.ProgColorList;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import de.p2tools.p2podder.controller.data.download.DownloadDataProps;
import javafx.scene.control.TableRow;
import javafx.scene.control.Tooltip;

public class TableRowDownload<T extends DownloadData>
extends TableRow<T> {
    @Override
    public void updateItem(T download, boolean empty) {
        super.updateItem(download, empty);
        if (download == null || empty) {
            this.setStyle("");
            this.setTooltip(null);
        } else {
            if (((DownloadData)download).getDownloadStart() != null && ((DownloadData)download).getDownloadStart().getStartStatus().isStateError()) {
                Tooltip tooltip = new Tooltip();
                tooltip.setText(((DownloadData)download).getDownloadStart().getStartStatus().getErrorMessage());
                this.setTooltip(tooltip);
            }
            switch (((DownloadDataProps)download).getState()) {
                case 2: {
                    if (ProgColorList.DOWNLOAD_WAIT_BG.isUse()) {
                        this.setStyle(ProgColorList.DOWNLOAD_WAIT_BG.getCssBackground());
                        break;
                    }
                    this.setStyle("");
                    break;
                }
                case 3: {
                    if (ProgColorList.DOWNLOAD_RUN_BG.isUse()) {
                        this.setStyle(ProgColorList.DOWNLOAD_RUN_BG.getCssBackground());
                        break;
                    }
                    this.setStyle("");
                    break;
                }
                case 4: {
                    if (ProgColorList.DOWNLOAD_FINISHED_BG.isUse()) {
                        this.setStyle(ProgColorList.DOWNLOAD_FINISHED_BG.getCssBackground());
                        break;
                    }
                    this.setStyle("");
                    break;
                }
                case 5: {
                    if (ProgColorList.DOWNLOAD_ERROR_BG.isUse()) {
                        this.setStyle(ProgColorList.DOWNLOAD_ERROR_BG.getCssBackground());
                        break;
                    }
                    this.setStyle("");
                    break;
                }
                default: {
                    this.setStyle("");
                }
            }
        }
    }
}

