/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.tools.table;

import de.p2tools.p2lib.guitools.P2TableFactory;
import de.p2tools.p2lib.mediathek.download.DownloadSizeData;
import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2podder.controller.config.PEvents;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import de.p2tools.p2podder.gui.tools.table.CellProgress;
import de.p2tools.p2podder.gui.tools.table.PTable;
import de.p2tools.p2podder.gui.tools.table.Table;
import de.p2tools.p2podder.gui.tools.table.TableDownloadFactory;
import java.time.LocalDate;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;

public class TableDownload
extends PTable<DownloadData> {
    private final ProgData progData;

    public TableDownload(Table.TABLE_ENUM table_enum, ProgData progData) {
        super(table_enum);
        this.table_enum = table_enum;
        this.progData = progData;
        this.addListener();
        this.initColumn();
    }

    @Override
    public Table.TABLE_ENUM getETable() {
        return this.table_enum;
    }

    public void resetTable() {
        this.initColumn();
        Table.resetTable(this);
    }

    private void refreshTable() {
        P2TableFactory.refreshTable(this);
    }

    private void addListener() {
        ProgConfig.SYSTEM_SMALL_BUTTON_TABLE_ROW.addListener((observableValue, s, t1) -> this.refresh());
        ProgData.getInstance().pEventHandler.addListener(new P2Listener(PEvents.EVENT_REFRESH_TABLE){

            public void pingGui(P2Event runEvent) {
                TableDownload.this.refreshTable();
            }
        });
    }

    private void initColumn() {
        this.getColumns().clear();
        this.setTableMenuButtonVisible(true);
        this.setEditable(false);
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        TableColumn<DownloadData, Integer> noColumn = new TableColumn<DownloadData, Integer>("Nr");
        noColumn.setCellValueFactory(new PropertyValueFactory("no"));
        noColumn.getStyleClass().add("alignCenterLeft");
        TableDownloadFactory.columnFactoryIntegerMax(this.table_enum, noColumn);
        TableColumn<DownloadData, String> genreColumn = new TableColumn<DownloadData, String>("Genre");
        genreColumn.setCellValueFactory(new PropertyValueFactory("genre"));
        genreColumn.getStyleClass().add("alignCenterLeft");
        TableDownloadFactory.columnFactoryString(this.table_enum, genreColumn);
        TableColumn<DownloadData, String> podcastNameColumn = new TableColumn<DownloadData, String>("Podcast");
        podcastNameColumn.setCellValueFactory(new PropertyValueFactory("podcastName"));
        podcastNameColumn.getStyleClass().add("alignCenterLeft");
        TableDownloadFactory.columnFactoryString(this.table_enum, podcastNameColumn);
        TableColumn<DownloadData, String> titleColumn = new TableColumn<DownloadData, String>("Titel");
        titleColumn.setCellValueFactory(new PropertyValueFactory("episodeTitle"));
        titleColumn.getStyleClass().add("alignCenterLeft");
        TableDownloadFactory.columnFactoryString(this.table_enum, titleColumn);
        TableColumn<DownloadData, Integer> startColumn = new TableColumn<DownloadData, Integer>("");
        startColumn.setCellValueFactory(new PropertyValueFactory("guiState"));
        startColumn.getStyleClass().add("alignCenter");
        TableDownloadFactory.columnFactoryButton(this.table_enum, startColumn);
        TableColumn<DownloadData, Double> progressColumn = new TableColumn<DownloadData, Double>("Fortschritt");
        progressColumn.setCellValueFactory(new PropertyValueFactory("guiProgress"));
        progressColumn.setCellFactory(new CellProgress<S, T>().cellFactory);
        progressColumn.getStyleClass().add("alignCenterLeft");
        TableDownloadFactory.columnFactoryProgress(this.table_enum, progressColumn);
        TableColumn<DownloadData, String> remainingColumn = new TableColumn<DownloadData, String>("Restzeit");
        remainingColumn.setCellValueFactory(new PropertyValueFactory("remaining"));
        remainingColumn.getStyleClass().add("alignCenterRightPadding_25");
        TableDownloadFactory.columnFactoryString(this.table_enum, remainingColumn);
        TableColumn<DownloadData, String> speedColumn = new TableColumn<DownloadData, String>("Geschwindigkeit");
        speedColumn.setCellValueFactory(new PropertyValueFactory("bandwidth"));
        speedColumn.getStyleClass().add("alignCenterRightPadding_25");
        TableDownloadFactory.columnFactoryString(this.table_enum, speedColumn);
        TableColumn<DownloadData, DownloadSizeData> downloadSizeColumn = new TableColumn<DownloadData, DownloadSizeData>("Gr\u00f6\u00dfe [MB]");
        downloadSizeColumn.setCellValueFactory(new PropertyValueFactory("downloadSize"));
        downloadSizeColumn.getStyleClass().add("alignCenter");
        TableDownloadFactory.columnFactoryDownloadSizeData(this.table_enum, downloadSizeColumn);
        TableColumn<DownloadData, Integer> durationColumn = new TableColumn<DownloadData, Integer>("Dauer");
        durationColumn.setCellValueFactory(new PropertyValueFactory("durationInt"));
        durationColumn.getStyleClass().add("alignCenter");
        TableDownloadFactory.columnFactoryDuration(this.table_enum, durationColumn);
        TableColumn<DownloadData, LocalDate> dateColumn = new TableColumn<DownloadData, LocalDate>("Datum");
        dateColumn.setCellValueFactory(new PropertyValueFactory("pubDate"));
        dateColumn.getStyleClass().add("alignCenter");
        TableDownloadFactory.columnFactoryLocalDate(this.table_enum, dateColumn);
        TableColumn<DownloadData, String> fileColumn = new TableColumn<DownloadData, String>("Dateiname");
        fileColumn.setCellValueFactory(new PropertyValueFactory("destFileName"));
        fileColumn.getStyleClass().add("alignCenterLeft");
        TableDownloadFactory.columnFactoryString(this.table_enum, fileColumn);
        TableColumn<DownloadData, String> pathColumn = new TableColumn<DownloadData, String>("Pfad");
        pathColumn.setCellValueFactory(new PropertyValueFactory("destPath"));
        pathColumn.getStyleClass().add("alignCenterLeft");
        TableDownloadFactory.columnFactoryString(this.table_enum, pathColumn);
        TableColumn<DownloadData, String> urlColumn = new TableColumn<DownloadData, String>("Url");
        urlColumn.setCellValueFactory(new PropertyValueFactory("episodeUrl"));
        urlColumn.getStyleClass().add("alignCenterLeft");
        TableDownloadFactory.columnFactoryString(this.table_enum, urlColumn);
        noColumn.setPrefWidth(50.0);
        genreColumn.setPrefWidth(120.0);
        podcastNameColumn.setPrefWidth(200.0);
        titleColumn.setPrefWidth(250.0);
        startColumn.setPrefWidth(120.0);
        remainingColumn.setPrefWidth(120.0);
        speedColumn.setPrefWidth(100.0);
        downloadSizeColumn.setPrefWidth(100.0);
        fileColumn.setPrefWidth(200.0);
        pathColumn.setPrefWidth(250.0);
        urlColumn.setPrefWidth(350.0);
        this.getColumns().addAll(noColumn, genreColumn, podcastNameColumn, titleColumn, startColumn, progressColumn, remainingColumn, speedColumn, downloadSizeColumn, durationColumn, dateColumn, fileColumn, pathColumn, urlColumn);
    }
}

