/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.smallgui;

import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.ProgQuitFactory;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import de.p2tools.p2podder.gui.smallgui.SmallGuiPack;
import java.util.Collection;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;

public class SmallGuiTop
extends HBox {
    private final ComboBox<Podcast> cboPodcast = new ComboBox();
    private final Button btnClearFilter = new Button();
    private final Button btnRadio = new Button("");
    private final Button btnClose = new Button();
    private final ProgData progData;
    private SmallGuiPack smallGuiPack;

    public SmallGuiTop(SmallGuiPack smallGuiPack) {
        this.smallGuiPack = smallGuiPack;
        this.progData = ProgData.getInstance();
        this.btnRadio.setTooltip(new Tooltip("gro\u00dfe Programmoberfl\u00e4che anzeigen"));
        this.btnRadio.setOnAction(e -> this.progData.smallGuiPack.close());
        this.btnRadio.setMaxWidth(Double.MAX_VALUE);
        this.btnRadio.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-2"});
        this.btnRadio.setGraphic(ProgIcons.ICON_MENU_SMALL_PODDER_20.getImageView());
        this.btnClose.setTooltip(new Tooltip("Programm beenden"));
        this.btnClose.setOnAction(e -> ProgQuitFactory.quit());
        this.btnClose.setMaxWidth(Double.MAX_VALUE);
        this.btnClose.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-2"});
        this.btnClose.setGraphic(ProgIcons.ICON_BUTTON_CLOSE.getImageView());
        this.btnClearFilter.setTooltip(new Tooltip("Filter l\u00f6schen"));
        this.btnClearFilter.setOnAction(e -> this.clearFilter());
        this.btnClearFilter.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-2"});
        this.btnClearFilter.setGraphic(ProgIcons.ICON_BUTTON_CLEAR_FILTER.getImageView());
        this.setAlignment(Pos.CENTER_LEFT);
        this.setSpacing(15.0);
        this.getChildren().addAll((Node[])new Node[]{this.btnRadio, P2GuiTools.getHDistance(25), this.cboPodcast, this.btnClearFilter, P2GuiTools.getHBoxGrower(), P2GuiTools.getHBoxGrower(), this.btnClose});
        this.initFilter();
    }

    public void clearFilter() {
        this.cboPodcast.getSelectionModel().clearSelection();
    }

    private void initFilter() {
        this.progData.episodeList.addListener((u, o, n) -> Platform.runLater(() -> {
            Podcast podcast = (Podcast)this.cboPodcast.getSelectionModel().getSelectedItem();
            this.cboPodcast.getItems().setAll((Collection<Podcast>)this.progData.episodeList.getPodcastList());
            if (podcast != null && this.cboPodcast.getItems().contains(podcast)) {
                this.cboPodcast.getSelectionModel().select(podcast);
            } else {
                this.cboPodcast.getSelectionModel().clearSelection();
            }
        }));
        this.cboPodcast.getItems().setAll((Collection<Podcast>)this.progData.episodeList.getPodcastList());
        this.cboPodcast.getSelectionModel().selectedItemProperty().addListener((u, o, n) -> {
            if (this.cboPodcast.getSelectionModel().isEmpty()) {
                this.progData.episodeFilterSmall.setPodcastId(0L);
            } else if (n != null && o != n) {
                this.progData.episodeFilterSmall.setPodcastId(n.getId());
            }
        });
    }
}

