/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.smallgui;

import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2TableFactory;
import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2podder.controller.config.PEvents;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.controller.data.episode.EpisodeFactory;
import de.p2tools.p2podder.gui.smallgui.SmallGuiPack;
import de.p2tools.p2podder.gui.smallgui.SmallGuiTableContextMenu;
import de.p2tools.p2podder.gui.tools.table.Table;
import de.p2tools.p2podder.gui.tools.table.TableRowEpisode;
import de.p2tools.p2podder.gui.tools.table.TableSmallEpisode;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class SmallGuiCenter
extends VBox {
    private final ScrollPane scrollPane = new ScrollPane();
    private final TableSmallEpisode tableView;
    private final ProgData progData;
    private final SmallGuiPack smallGuiPack;

    public SmallGuiCenter(SmallGuiPack smallGuiPack) {
        this.smallGuiPack = smallGuiPack;
        this.progData = ProgData.getInstance();
        this.tableView = new TableSmallEpisode(Table.TABLE_ENUM.SMALL_EPISODE, this.progData);
        this.getChildren().addAll((Node[])new Node[]{this.scrollPane});
        VBox.setVgrow(this.scrollPane, Priority.ALWAYS);
        this.initTable();
        this.initListener();
    }

    public void tableRefresh() {
        this.tableView.refresh();
    }

    public void isShown() {
        this.tableView.requestFocus();
    }

    public int getFavouritesShown() {
        return this.tableView.getItems().size();
    }

    public void saveTable() {
        Table.saveTable(this.tableView, Table.TABLE_ENUM.SMALL_EPISODE);
    }

    public ArrayList<Episode> getSelList() {
        ArrayList<Episode> ret = new ArrayList<Episode>(this.tableView.getSelectionModel().getSelectedItems());
        if (ret.isEmpty()) {
            P2Alert.showInfoNoSelection();
        }
        return ret;
    }

    public Optional<Episode> getSel() {
        return this.getSel(true);
    }

    public Optional<Episode> getSel(boolean show) {
        int selectedTableRow = this.tableView.getSelectionModel().getSelectedIndex();
        if (selectedTableRow >= 0) {
            return Optional.of((Episode)this.tableView.getSelectionModel().getSelectedItem());
        }
        if (show) {
            P2Alert.showInfoNoSelection();
        }
        return Optional.empty();
    }

    public void playEpisode() {
        ArrayList<Episode> ret = this.getSelList();
        EpisodeFactory.playEpisode(ret, null);
    }

    public void setNextEpisode() {
        P2TableFactory.selectNextRow(this.tableView);
    }

    public void setPreviousEpisode() {
        P2TableFactory.selectPreviousRow(this.tableView);
    }

    public void playRandomStation() {
        Random r = new Random();
        Episode episode = (Episode)this.tableView.getItems().get(r.nextInt(this.tableView.getItems().size()));
        if (episode != null) {
            EpisodeFactory.playEpisode(episode);
            this.tableView.getSelectionModel().select(episode);
            this.tableView.scrollTo(episode);
        }
    }

    private void initListener() {
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_SETDATA_CHANGED){

            public void pingGui(P2Event runEvent) {
                P2TableFactory.refreshTable(SmallGuiCenter.this.tableView);
            }
        });
    }

    private void initTable() {
        Table.setTable(this.tableView);
        this.scrollPane.setFitToHeight(true);
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setContent(this.tableView);
        this.tableView.setItems(this.progData.episodeList.getSmallSortedList());
        this.progData.episodeList.getSmallSortedList().comparatorProperty().bind(this.tableView.comparatorProperty());
        this.tableView.getItems().addListener(c -> {
            if (this.tableView.getItems().size() == 1) {
                this.tableView.getSelectionModel().select(0);
            }
        });
        this.tableView.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                Optional<Episode> optionalDownload = this.getSel(false);
                Episode episode = optionalDownload.orElse(null);
                ContextMenu contextMenu = new SmallGuiTableContextMenu(this.progData, this, this.tableView).getContextMenu(episode);
                this.tableView.setContextMenu(contextMenu);
            }
        });
        this.tableView.setOnMouseClicked(m -> {
            Optional<Episode> optionalDownload = this.getSel(false);
            if (m.getButton().equals((Object)MouseButton.PRIMARY) && m.getClickCount() == 2) {
                this.progData.episodeInfoDialogController.toggleShowInfo();
            }
        });
        this.tableView.setRowFactory(tableView -> {
            TableRowEpisode row = new TableRowEpisode();
            row.hoverProperty().addListener(observable2 -> {
                Episode episode = (Episode)row.getItem();
                if (row.isHover() && episode != null) {
                    this.progData.episodeInfoDialogController.setEpisode(episode);
                    this.smallGuiPack.setEpisodeInfoBox(episode);
                } else {
                    this.setSelectedEpisode();
                }
            });
            return row;
        });
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> this.setSelectedEpisode());
        this.tableView.addEventFilter(KeyEvent.KEY_PRESSED, (? super T event) -> {
            if (P2TableFactory.SPACE.match((KeyEvent)event)) {
                P2TableFactory.scrollVisibleRangeDown(this.tableView);
                event.consume();
            }
            if (P2TableFactory.SPACE_SHIFT.match((KeyEvent)event)) {
                P2TableFactory.scrollVisibleRangeUp(this.tableView);
                event.consume();
            }
        });
    }

    private void setSelectedEpisode() {
        Episode episode = (Episode)this.tableView.getSelectionModel().getSelectedItem();
        this.progData.episodeInfoDialogController.setEpisode(episode);
        this.smallGuiPack.setEpisodeInfoBox(episode);
    }
}

