/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.filter;

import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadFactory;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import de.p2tools.p2podder.controller.filter.FilterCheckRegEx;
import java.util.Collection;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class DownloadFilterController
extends VBox {
    private final ScrollPane scrollPane = new ScrollPane();
    private TableView<Podcast> tableView = new TableView();
    private ComboBox<String> cboGenre = new ComboBox();
    private TextField txtTitle = new TextField();
    private ProgData progData;
    private Callback<TableColumn<Podcast, String>, TableCell<Podcast, String>> cellFactory = param -> {
        TableCell<Podcast, String> cell = new TableCell<Podcast, String>(){

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                VBox vBox = new VBox();
                vBox.setSpacing(5.0);
                vBox.setAlignment(Pos.CENTER_LEFT);
                vBox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
                Podcast podcast = (Podcast)this.getTableView().getItems().get(this.getIndex());
                String name = podcast.getName();
                String genre = podcast.getGenre();
                String count = "" + DownloadFactory.countDownload(podcast);
                Label lblCount = new Label(count);
                Label lblName = new Label(name);
                Label lblGenre = new Label(genre);
                lblCount.getStyleClass().add("lblCount");
                lblCount.setMinWidth(Double.NEGATIVE_INFINITY);
                VBox vBox1 = new VBox();
                vBox1.getChildren().addAll((Node[])new Node[]{lblName, lblGenre});
                HBox hBox = new HBox();
                hBox.setSpacing(10.0);
                hBox.setAlignment(Pos.CENTER_LEFT);
                hBox.getChildren().addAll((Node[])new Node[]{lblCount, vBox1});
                vBox.getChildren().add(hBox);
                this.setGraphic(vBox);
            }
        };
        return cell;
    };

    public DownloadFilterController() {
        this.progData = ProgData.getInstance();
        VBox vBoxGenre = new VBox();
        this.cboGenre.setMaxWidth(Double.MAX_VALUE);
        vBoxGenre.getChildren().addAll((Node[])new Node[]{new Label("Genre: "), this.cboGenre});
        VBox vBoxTitle = new VBox();
        vBoxTitle.getChildren().addAll((Node[])new Node[]{new Label("Titel:"), this.txtTitle});
        VBox.setVgrow(this, Priority.ALWAYS);
        this.setPadding(new Insets(10.0));
        this.setSpacing(5.0);
        this.getChildren().addAll((Node[])new Node[]{this.scrollPane, vBoxGenre, vBoxTitle, P2GuiTools.getVBoxGrower()});
        this.addButton();
        this.initTable();
        this.initFilter();
    }

    private void addButton() {
        Button btnClearFilter = new Button("");
        btnClearFilter.setGraphic(ProgIcons.ICON_BUTTON_CLEAR_FILTER.getImageView());
        btnClearFilter.setOnAction(a -> this.clearFilter(true));
        btnClearFilter.setTooltip(new Tooltip("Alle Filter l\u00f6schen"));
        HBox hBox = new HBox(5.0);
        hBox.setAlignment(Pos.CENTER_RIGHT);
        hBox.getChildren().addAll((Node[])new Node[]{btnClearFilter});
        Separator separator = new Separator();
        separator.getStyleClass().add("pseperator2");
        this.getChildren().addAll((Node[])new Node[]{separator, hBox});
    }

    private void initTable() {
        this.scrollPane.setFitToHeight(true);
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setContent(this.tableView);
        TableColumn episodeColumn = new TableColumn("Podcast");
        episodeColumn.setCellValueFactory(new PropertyValueFactory("name"));
        episodeColumn.setCellFactory(this.cellFactory);
        episodeColumn.getStyleClass().add("alignCenterLeft");
        this.tableView.getColumns().addAll(episodeColumn);
        this.tableView.setEditable(false);
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
    }

    public void initFilter() {
        this.tableView.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2) {
                    this.tableView.getSelectionModel().clearSelection();
                }
            });
            return row;
        });
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> {
            if (this.tableView.getSelectionModel().isEmpty()) {
                this.progData.downloadFilter.setPodcastId(0L);
            } else if (newValue != null) {
                long l = ((Podcast)this.tableView.getSelectionModel().getSelectedItem()).getId();
                this.progData.downloadFilter.setPodcastId(l);
            }
        });
        this.progData.downloadList.addListener((v, o, n) -> Platform.runLater(() -> {
            Podcast sel = (Podcast)this.tableView.getSelectionModel().getSelectedItem();
            this.tableView.getItems().setAll((Collection<Podcast>)DownloadFactory.getPodcastList());
            if (this.tableView.getItems().contains(sel)) {
                this.tableView.getSelectionModel().select(sel);
            } else {
                this.clearFilter(false);
            }
        }));
        this.tableView.getItems().addAll((Collection<Podcast>)DownloadFactory.getPodcastList());
        this.cboGenre.getItems().addAll((Collection<String>)this.progData.downloadList.getGenreList());
        this.progData.downloadList.getGenreList().addListener(change -> Platform.runLater(() -> {
            String sel = (String)this.cboGenre.getSelectionModel().getSelectedItem();
            this.cboGenre.getItems().setAll((Collection<String>)this.progData.downloadList.getGenreList());
            if (!sel.isEmpty()) {
                if (this.cboGenre.getItems().contains(sel)) {
                    this.cboGenre.getSelectionModel().select(sel);
                } else {
                    this.clearFilter(false);
                }
            }
        }));
        this.cboGenre.valueProperty().bindBidirectional(this.progData.downloadFilter.genreProperty());
        this.txtTitle.textProperty().bindBidirectional(this.progData.downloadFilter.titleProperty());
        FilterCheckRegEx fT = new FilterCheckRegEx(this.txtTitle);
        this.txtTitle.textProperty().addListener((observable2, oldValue, newValue) -> fT.checkPattern());
    }

    public void clearFilter(boolean clearTable) {
        P2Duration.onlyPing("Filter l\u00f6schen");
        this.progData.downloadFilter.clearFilter();
        if (clearTable) {
            this.tableView.getSelectionModel().clearSelection();
        }
    }
}

