/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.dialog;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2BigButton;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.ProgQuitFactory;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.gui.dialog.ImportSetDialogController;
import de.p2tools.p2podder.gui.tools.HelpText;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;

public class ResetDialogController
extends P2DialogExtra {
    final ProgData progData;
    final StackPane stackPane;

    public ResetDialogController(ProgData progData) {
        super(progData.primaryStage, null, "Programm zur\u00fccksetzen", true, false);
        this.progData = progData;
        this.stackPane = new StackPane();
        this.init(true);
    }

    @Override
    public void make() {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(15.0);
        gridPane.setVgap(25.0);
        Label headerLabel = new Label("Einstellungen k\u00f6nnen komplett oder" + P2LibConst.LINE_SEPARATOR + "nur die Sets zum Abspielen" + P2LibConst.LINE_SEPARATOR + "zur\u00fcckgesetzt werden!");
        headerLabel.setStyle("-fx-font-size: 1.5em;");
        P2BigButton cancelButton = new P2BigButton(ProgIcons.ICON_BUTTON_QUIT.getImageView(), "Nichts \u00e4ndern", "");
        cancelButton.setOnAction(e -> this.close());
        Button btnHelp = P2Button.helpButton(this.getStage(), "Programm zur\u00fccksetzen", HelpText.RESET_DIALOG);
        P2BigButton setButton = new P2BigButton(ProgIcons.ICON_BUTTON_QUIT.getImageView(), "Einstellungen zum Abspielen zur\u00fccksetzen", "Es werden alle Programmsets (auch eigene) gel\u00f6scht" + P2LibConst.LINE_SEPARATOR + "und die Standardsets wieder angelegt.");
        setButton.setOnAction(e -> {
            Platform.runLater(() -> {
                ImportSetDialogController importSetDialogController = new ImportSetDialogController(this.progData);
                importSetDialogController.close();
            });
            this.close();
        });
        P2BigButton allButton = new P2BigButton(ProgIcons.ICON_BUTTON_QUIT.getImageView(), "Alle Einstellungen zur\u00fccksetzen!", "ACHTUNG!" + P2LibConst.LINE_SEPARATOR + "Alle Einstellungen gehen verloren!");
        allButton.setOnAction(e -> {
            Text t = new Text("ALLE");
            t.setFont(Font.font(null, FontWeight.BOLD, -1.0));
            TextFlow tf = new TextFlow();
            tf.getChildren().addAll((Node[])new Node[]{new Text("Es werden "), t, new Text(" von Ihnen erzeugten \u00c4nderungen gel\u00f6scht." + P2LibConst.LINE_SEPARATORx2 + "M\u00f6chten Sie wirklich alle Einstellungen zur\u00fccksetzen?")});
            if (P2Alert.showAlert_yes_no_cancel("Einstellungen zur\u00fccksetzen", "alle Einstellungen zur\u00fccksetzen!", tf, false) == P2Alert.BUTTON.YES) {
                ProgData.reset = true;
                Stage stage = null;
                if (this.progData.smallGuiPack != null) {
                    stage = this.progData.smallGuiPack.getStage();
                } else if (this.progData.primaryStage.isShowing()) {
                    stage = this.progData.primaryStage;
                }
                ProgQuitFactory.quit();
            }
        });
        gridPane.add(ProgIcons.IMAGE_ATTENTION_64.getImageView(), 0, 0, 1, 1);
        gridPane.add(headerLabel, 1, 0);
        gridPane.add(cancelButton, 1, 1);
        gridPane.add(btnHelp, 2, 1);
        gridPane.add(setButton, 1, 2);
        gridPane.add(allButton, 1, 3);
        ColumnConstraints ccTxt = new ColumnConstraints();
        ccTxt.setFillWidth(true);
        ccTxt.setMinWidth(-1.0);
        ccTxt.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{new ColumnConstraints(), ccTxt});
        this.getVBoxCont().getChildren().addAll((Node[])new Node[]{gridPane});
    }
}

