/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.dialog;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.tools.file.P2FileUtils;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.episode.Episode;
import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class EpisodeDelDialogController
extends P2DialogExtra {
    private final Button btnOk = new Button("_Ok");
    private final Button btnCancel = new Button("_Abbrechen");
    private final CheckBox chkDontAsk = new CheckBox("Einstellung merken, nicht mehr fragen");
    private final CheckBox chkDelFile = new CheckBox("Auch die Dateien l\u00f6schen");
    private boolean ok = false;
    private List<Episode> episodeList;
    private final ProgData progData;

    public EpisodeDelDialogController(ProgData progData, List<Episode> episodeList) {
        super(progData.primaryStage, ProgConfig.SYSTEM_SIZE_DIALOG_EPISODE_DEL, "Episoden l\u00f6schen", true, true, P2DialogExtra.DECO.BORDER_SMALL);
        this.progData = progData;
        this.episodeList = episodeList;
        this.init(true);
    }

    @Override
    public void close() {
        super.close();
    }

    public boolean isOk() {
        return this.ok;
    }

    @Override
    public void make() {
        this.addOkButton(this.btnOk);
        this.addCancelButton(this.btnCancel);
        this.btnOk.setOnAction(event -> {
            this.ok = true;
            this.close();
        });
        this.btnCancel.setOnAction(event -> {
            this.ok = false;
            this.close();
        });
        this.getHboxLeft().getChildren().addAll((Node[])new Node[]{this.chkDontAsk});
        this.getHBoxOverButtons().getChildren().add(this.chkDelFile);
        this.getHBoxOverButtons().setAlignment(Pos.CENTER_RIGHT);
        this.makeCont();
    }

    private void makeCont() {
        this.chkDontAsk.setSelected((Boolean)ProgConfig.SYSTEM_DELETE_EPISODE_FILE_ASK.not().getValue());
        this.chkDontAsk.selectedProperty().addListener((observable2, oldValue, newValue) -> ProgConfig.SYSTEM_DELETE_EPISODE_FILE_ASK.setValue(!this.chkDontAsk.isSelected()));
        this.chkDelFile.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_DELETE_EPISODE_FILE);
        HBox.setHgrow(this.chkDontAsk, Priority.ALWAYS);
        Label txt = new Label("Sollen die Episoden und die Dateien gel\u00f6scht werden?");
        ListView listView = new ListView();
        this.episodeList.stream().forEach(episode -> {
            String path = episode.getEpisodeTitle() + P2LibConst.LINE_SEPARATOR + P2FileUtils.addsPath(episode.getFilePath(), episode.getFileName());
            listView.getItems().add(path);
        });
        this.getVBoxCont().getChildren().addAll((Node[])new Node[]{txt, listView});
    }
}

