/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.dialog;

import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2BigButton;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.PEvents;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadFactory;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class AutoDialog
extends P2DialogExtra {
    private final ProgData progData;
    private long maxDownload = 0L;
    private final Label lblParse = new Label();
    private final Label lblDownload = new Label();
    private final ProgressBar progressBarParse = new ProgressBar();
    private final ProgressBar progressBarDownload = new ProgressBar();

    public AutoDialog(ProgData progData) {
        super(progData.primaryStage, null, "Auto-Mode", true, false, P2DialogExtra.DECO.BORDER_SMALL);
        this.progData = progData;
        this.init(true);
    }

    @Override
    public void make() {
        this.initCont();
    }

    private void initCont() {
        Label headerLabel = new Label("Downloads suchen und laden!");
        headerLabel.setStyle("-fx-font-size: 1.5em;");
        P2BigButton cancelButton = new P2BigButton(ProgIcons.ICON_BUTTON_QUIT.getImageView(), "Auto-Mode abbrechen", "Das Programm l\u00e4uft dann normal weiter");
        cancelButton.setOnAction(e -> {
            ProgData.auto = false;
            this.close();
        });
        VBox vBox = this.getVBoxCont();
        vBox.setPadding(new Insets(15.0));
        vBox.setSpacing(2.0);
        vBox.getChildren().add(headerLabel);
        vBox.getChildren().add(P2GuiTools.getHDistance(15));
        vBox.getChildren().add(cancelButton);
        vBox.getChildren().add(P2GuiTools.getHDistance(25));
        vBox.getChildren().add(this.progressBarParse);
        HBox hBox = new HBox(10.0);
        hBox.getChildren().addAll((Node[])new Node[]{new Label("Suchen"), P2GuiTools.getHBoxGrower(), this.lblParse});
        vBox.getChildren().add(hBox);
        vBox.getChildren().add(P2GuiTools.getHDistance(15));
        vBox.getChildren().add(this.progressBarDownload);
        hBox = new HBox(10.0);
        hBox.getChildren().addAll((Node[])new Node[]{new Label("Laden"), P2GuiTools.getHBoxGrower(), this.lblDownload});
        vBox.getChildren().add(hBox);
        GridPane.setHalignment(this.lblDownload, HPos.RIGHT);
        this.addProgress();
    }

    private void addProgress() {
        this.progressBarParse.setMaxWidth(Double.MAX_VALUE);
        this.progressBarParse.setProgress(0.0);
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_PARSE_PODCAST){

            public void pingGui(P2Event runEvent) {
                AutoDialog.this.setProgressParse(runEvent);
            }
        });
        this.progressBarDownload.setMaxWidth(Double.MAX_VALUE);
        this.progressBarDownload.setProgress(0.0);
        this.setProgressDownload();
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_TIMER_SECOND){

            public void pingGui(P2Event runEvent) {
                AutoDialog.this.setProgressDownload();
            }
        });
    }

    private void setProgressParse(P2Event events) {
        int countParse = (int)events.getAct();
        long podcastSize = this.progData.podcastList.size();
        double progress = 1.0 * (double)podcastSize / (double)countParse;
        progress = 100.0 / progress / 100.0;
        this.lblParse.setText("Anzahl: " + countParse + " von " + podcastSize);
        this.progressBarParse.setProgress(progress);
    }

    private void setProgressDownload() {
        long sum = DownloadFactory.getDownloadsWaiting();
        double progress = 0.0;
        if (this.maxDownload < sum) {
            this.maxDownload = sum;
        }
        if (this.maxDownload > 0L) {
            progress = 100.0 * (double)sum / (double)this.maxDownload;
            progress = 100.0 - progress;
            progress /= 100.0;
        }
        this.lblDownload.setText("Anzahl: " + (this.maxDownload - sum) + " von " + this.maxDownload);
        this.progressBarDownload.setProgress(progress);
    }
}

