/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.configdialog;

import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import java.util.Collection;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class PaneProg {
    private final ProgData progData;
    StringProperty propUrl = ProgConfig.SYSTEM_PROG_OPEN_URL;
    private TextField txtFileManagerWeb;
    private final Stage stage;

    public PaneProg(Stage stage) {
        this.stage = stage;
        this.progData = ProgData.getInstance();
    }

    public void close() {
        this.txtFileManagerWeb.textProperty().unbindBidirectional(ProgConfig.SYSTEM_PROG_OPEN_URL);
    }

    public void makeProg(Collection<TitledPane> result) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        TitledPane tpConfig = new TitledPane("Programme", gridPane);
        result.add(tpConfig);
        this.addWebbrowser(gridPane, 0);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow()});
    }

    private void addWebbrowser(GridPane gridPane, int row) {
        gridPane.add(new Label("Webbrowser zum \u00d6ffnen von URLs"), 0, row);
        this.txtFileManagerWeb = new TextField();
        this.txtFileManagerWeb.textProperty().bindBidirectional(ProgConfig.SYSTEM_PROG_OPEN_URL);
        Button btnFile = new Button();
        btnFile.setOnAction(event -> P2DirFileChooser.FileChooserOpenFile(ProgData.getInstance().primaryStage, this.txtFileManagerWeb));
        btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        btnFile.setTooltip(new Tooltip("Einen Webbrowser zum \u00d6ffnen von URLs ausw\u00e4hlen"));
        Button btnHelp = P2Button.helpButton(this.stage, "Webbrowser", "Wenn das Programm versucht, einen Link zu \u00f6ffnen (z.B. den Link im Men\u00fcpunkt \"Hilfe\" zu den \"Hilfeseiten\") und die Standardanwendung (z.B. \"Firefox\") nicht startet, kann damit ein Programm ausgew\u00e4hlt und fest zugeordnet werden (z.B. der Browser \"Firefox\").\n");
        gridPane.add(this.txtFileManagerWeb, 0, row + 1);
        gridPane.add(btnFile, 1, row + 1);
        gridPane.add(btnHelp, 2, row + 1);
    }
}

