/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.configdialog;

import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.config.ProgInfosFactory;
import de.p2tools.p2podder.gui.tools.HelpText;
import java.util.Collection;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;

public class PanePodcast {
    private final ProgData progData;
    private TextField txtPodDest = new TextField();
    private final P2ToggleSwitch tglUpdatePodcastDaily = new P2ToggleSwitch("Die Podcasts einmal am Tage aktualisieren");
    private final P2ToggleSwitch tglStartDownload = new P2ToggleSwitch("und den Download der Episoden gleich starten");
    private final Stage stage;

    public PanePodcast(Stage stage) {
        this.stage = stage;
        this.progData = ProgData.getInstance();
    }

    public void close() {
        this.txtPodDest.textProperty().unbindBidirectional(ProgConfig.SYSTEM_POD_DIR);
        this.tglUpdatePodcastDaily.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_UPDATE_PODCAST_DAILY);
        this.tglStartDownload.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_START_DAILY_DOWNLOAD);
    }

    public void makePane(Collection<TitledPane> result) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        TitledPane tpConfig = new TitledPane("Speicherordner", gridPane);
        result.add(tpConfig);
        Button btnHelp = P2Button.helpButton(this.stage, "Speicherordner Podcasts", HelpText.DEST_DIR);
        this.txtPodDest.textProperty().bindBidirectional(ProgConfig.SYSTEM_POD_DIR);
        if (this.txtPodDest.getText().isEmpty()) {
            this.txtPodDest.setText(ProgInfosFactory.getStandardPodDestString());
        }
        Button btnFile = new Button();
        btnFile.setTooltip(new Tooltip("Einen Ordner f\u00fcr die Podcasts ausw\u00e4hlen"));
        btnFile.setOnAction(event -> P2DirFileChooser.DirChooser(ProgData.getInstance().primaryStage, this.txtPodDest));
        btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        Button btnReset = new Button();
        btnReset.setGraphic(ProgIcons.ICON_BUTTON_PROPOSE.getImageView());
        btnReset.setTooltip(new Tooltip("Standardpfad f\u00fcr die Podcasts wieder herstellen"));
        btnReset.setOnAction(event -> this.txtPodDest.setText(ProgInfosFactory.getStandardPodDestString()));
        this.tglUpdatePodcastDaily.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_UPDATE_PODCAST_DAILY);
        this.tglStartDownload.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_START_DAILY_DOWNLOAD);
        this.tglStartDownload.disableProperty().bind(ProgConfig.SYSTEM_UPDATE_PODCAST_DAILY.not());
        this.tglUpdatePodcastDaily.selectedProperty().addListener((u, o, n) -> {
            if (!this.tglUpdatePodcastDaily.isSelected()) {
                this.tglStartDownload.setSelected(false);
            }
        });
        Button btnHelpLoadStationList = P2Button.helpButton(this.stage, "Nach neuen Episoden suchen", HelpText.LOAD_PODCASTS_EVERY_DAYS);
        GridPane.setHalignment(btnHelpLoadStationList, HPos.RIGHT);
        int row = 0;
        gridPane.add(new Label("Ordner:"), 0, row);
        gridPane.add(this.txtPodDest, 1, row);
        HBox hBox = new HBox(5.0);
        hBox.getChildren().addAll((Node[])new Node[]{btnFile, btnReset});
        hBox.setAlignment(Pos.CENTER_RIGHT);
        gridPane.add(hBox, 2, row);
        gridPane.add(btnHelp, 3, row);
        gridPane.add(new Label(), 0, ++row);
        gridPane.add(this.tglUpdatePodcastDaily, 0, ++row, 3, 1);
        gridPane.add(btnHelpLoadStationList, 3, row);
        hBox = new HBox();
        hBox.getChildren().addAll((Node[])new Node[]{new Label("    "), this.tglStartDownload});
        HBox.setHgrow(this.tglStartDownload, Priority.ALWAYS);
        gridPane.add(hBox, 0, ++row, 3, 1);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize()});
    }
}

