/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.configdialog;

import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import de.p2tools.p2lib.tools.log.P2Logger;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.config.ProgInfos;
import de.p2tools.p2podder.gui.tools.HelpText;
import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class PaneLogFile {
    private final BooleanProperty logfileChanged = new SimpleBooleanProperty(false);
    private final P2ToggleSwitch tglEnableLog = new P2ToggleSwitch("Ein Logfile anlegen:");
    private final Label lblStandardLogDir = new Label("");
    private TextField txtLogFile;
    private final Stage stage;

    public PaneLogFile(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        this.tglEnableLog.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_LOG_ON);
        this.txtLogFile.textProperty().unbindBidirectional(ProgConfig.SYSTEM_LOG_DIR);
    }

    public void makeLogfile(Collection<TitledPane> result) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        TitledPane tpConfig = new TitledPane("Logfile", gridPane);
        result.add(tpConfig);
        this.tglEnableLog.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_LOG_ON);
        this.tglEnableLog.selectedProperty().addListener((observable2, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            if (newValue.booleanValue()) {
                P2Logger.setFileHandler(ProgInfos.getLogDirectory_String());
            } else {
                P2Logger.removeFileHandler();
            }
        });
        Button btnHelp = P2Button.helpButton(this.stage, "Logfile", HelpText.LOGFILE);
        this.txtLogFile = new TextField();
        this.txtLogFile.textProperty().bindBidirectional(ProgConfig.SYSTEM_LOG_DIR);
        Button btnFile = new Button();
        btnFile.setTooltip(new Tooltip("Einen Ordner f\u00fcr das Logfile ausw\u00e4hlen"));
        btnFile.setOnAction(event -> P2DirFileChooser.DirChooser(ProgData.getInstance().primaryStage, this.txtLogFile));
        btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        Button btnClear = new Button();
        btnClear.setGraphic(ProgIcons.ICON_BUTTON_CLEAN.getImageView());
        btnClear.setTooltip(new Tooltip("Pfad l\u00f6schen"));
        btnClear.setOnAction(event -> this.txtLogFile.setText(""));
        Button btnChange = new Button("_Pfad zum Logfile jetzt schon \u00e4ndern");
        btnChange.setTooltip(new Tooltip("Den ge\u00e4nderten Pfad f\u00fcr das Logfile\njetzt schon verwenden, \n\nansonsten wird er erst beim n\u00e4chsten\nProgrammstart verwendet"));
        btnChange.setOnAction(event -> {
            P2Logger.setFileHandler(ProgInfos.getLogDirectory_String());
            this.logfileChanged.setValue(false);
        });
        Label lblPath = new Label("Eigener Pfad:");
        this.lblStandardLogDir.visibleProperty().bind(this.tglEnableLog.selectedProperty());
        this.txtLogFile.textProperty().addListener((u, o, n) -> this.setLabel());
        this.setLabel();
        int row = 0;
        gridPane.add(this.tglEnableLog, 0, row, 3, 1);
        gridPane.add(btnHelp, 3, row);
        gridPane.add(this.lblStandardLogDir, 0, ++row, 4, 1);
        gridPane.add(new Label(""), 0, ++row);
        gridPane.add(lblPath, 0, ++row);
        gridPane.add(this.txtLogFile, 1, row);
        gridPane.add(btnFile, 2, row);
        gridPane.add(btnClear, 3, row);
        gridPane.add(btnChange, 0, ++row, 4, 1);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize()});
        lblPath.disableProperty().bind(this.tglEnableLog.selectedProperty().not());
        this.txtLogFile.disableProperty().bind(this.tglEnableLog.selectedProperty().not());
        btnFile.disableProperty().bind(this.tglEnableLog.selectedProperty().not());
        btnClear.disableProperty().bind(this.tglEnableLog.selectedProperty().not());
        btnChange.disableProperty().bind(this.tglEnableLog.selectedProperty().not().or(this.logfileChanged.not()));
        this.txtLogFile.textProperty().addListener((observable2, oldValue, newValue) -> this.logfileChanged.setValue(true));
    }

    private void setLabel() {
        if (this.txtLogFile.getText().isEmpty()) {
            this.lblStandardLogDir.setText("Standard-Pfad:  " + ProgInfos.getStandardLogDirectory_String());
        } else {
            this.lblStandardLogDir.setText("");
        }
    }
}

