/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui;

import de.p2tools.p2lib.tools.P2ToolsFactory;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import de.p2tools.p2podder.gui.PodcastGuiController;
import de.p2tools.p2podder.gui.tools.table.TablePodcast;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;

public class PodcastGuiTableContextMenu {
    private final ProgData progData;
    private final PodcastGuiController podcastGuiController;
    private final TablePodcast tableView;

    public PodcastGuiTableContextMenu(ProgData progData, PodcastGuiController podcastGuiController, TablePodcast tableView) {
        this.progData = progData;
        this.podcastGuiController = podcastGuiController;
        this.tableView = tableView;
    }

    public ContextMenu getContextMenu(Podcast podcast) {
        ContextMenu contextMenu = new ContextMenu();
        this.getMenu(contextMenu, podcast);
        return contextMenu;
    }

    private void getMenu(ContextMenu contextMenu, Podcast podcast) {
        MenuItem miStart = new MenuItem("Podcast aktualisieren");
        miStart.setOnAction(a -> this.progData.worker.updateSelectedPodcast());
        MenuItem miDel = new MenuItem("Podcast l\u00f6schen");
        miDel.setOnAction(a -> this.podcastGuiController.delPodcast());
        MenuItem miSetActive = new MenuItem("Podcasts einschalten");
        miSetActive.setOnAction(a -> this.progData.worker.setPodcastActive(true));
        MenuItem miSetOffActive = new MenuItem("Podcasts ausschalten");
        miSetOffActive.setOnAction(a -> this.progData.worker.setPodcastActive(false));
        MenuItem miCopyUrl = new MenuItem("Podcast-URL kopieren");
        miCopyUrl.setOnAction(a -> P2ToolsFactory.copyToClipboard(podcast.getUrl()));
        MenuItem miStationInfo = new MenuItem("Podcast-Info anzeigen");
        miStart.setDisable(podcast == null);
        miDel.setDisable(podcast == null);
        miSetActive.setDisable(podcast == null);
        miSetOffActive.setDisable(podcast == null);
        miCopyUrl.setDisable(podcast == null);
        miStationInfo.setDisable(podcast == null);
        boolean isActive = podcast != null && podcast.isActive();
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miStart, miDel, isActive ? miSetOffActive : miSetActive, miCopyUrl, miStationInfo});
        MenuItem resetTable = new MenuItem("Tabelle zur\u00fccksetzen");
        resetTable.setOnAction(a -> this.tableView.resetTable());
        contextMenu.getItems().add(new SeparatorMenuItem());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{resetTable});
    }
}

