/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui;

import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2Hyperlink;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.data.episode.Episode;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class PaneEpisodeInfo
extends VBox {
    private final Label lblTitle = new Label("");
    private final Label lblGenre = new Label("");
    private final Label lblDate = new Label("");
    private final Label lblLength = new Label("");
    private final Label size = new Label("");
    private final P2Hyperlink hyperlinkWebsite = new P2Hyperlink("", ProgConfig.SYSTEM_PROG_OPEN_URL);
    private final TextArea taDescription = new TextArea();
    private Episode episode = null;

    public PaneEpisodeInfo() {
        this.initInfo();
        VBox.setVgrow(this, Priority.ALWAYS);
    }

    public void initInfo() {
        GridPane gridPaneLeft = new GridPane();
        GridPane gridPaneRight = new GridPane();
        SplitPane splitPane = new SplitPane();
        splitPane.getItems().addAll((Node[])new Node[]{gridPaneLeft, gridPaneRight});
        ((SplitPane.Divider)splitPane.getDividers().get(0)).positionProperty().bindBidirectional(ProgConfig.EPISODE_GUI_INFO_DIVIDER);
        VBox.setVgrow(splitPane, Priority.ALWAYS);
        this.getChildren().add(splitPane);
        this.lblTitle.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        this.taDescription.setEditable(true);
        this.taDescription.setWrapText(true);
        this.taDescription.setPrefRowCount(2);
        gridPaneLeft.setHgap(5.0);
        gridPaneLeft.setVgap(5.0);
        gridPaneLeft.setPadding(new Insets(10.0));
        gridPaneLeft.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        int row = 0;
        gridPaneLeft.add(new Label("Titel: "), 0, row);
        gridPaneLeft.add(this.lblTitle, 1, row);
        gridPaneLeft.add(new Label("Website: "), 0, ++row);
        gridPaneLeft.add(this.hyperlinkWebsite, 1, row);
        gridPaneLeft.add(new Label("Beschreibung:"), 0, ++row);
        gridPaneLeft.add(this.taDescription, 1, row);
        GridPane.setVgrow(this.taDescription, Priority.ALWAYS);
        gridPaneRight.setHgap(5.0);
        gridPaneRight.setVgap(5.0);
        gridPaneRight.setPadding(new Insets(10.0));
        gridPaneRight.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        row = 0;
        gridPaneRight.add(new Label("Genre:"), 0, row);
        gridPaneRight.add(this.lblGenre, 1, row);
        gridPaneRight.add(new Label("Datum:"), 0, ++row);
        gridPaneRight.add(this.lblDate, 1, row);
        gridPaneRight.add(new Label("Dauer:"), 0, ++row);
        gridPaneRight.add(this.lblLength, 1, row);
        gridPaneRight.add(new Label("Gr\u00f6\u00dfe:"), 0, ++row);
        gridPaneRight.add(this.size, 1, row);
        VBox.setVgrow(gridPaneLeft, Priority.ALWAYS);
    }

    public void setEpisode(Episode episode) {
        if (this.episode != null) {
            this.taDescription.textProperty().unbindBidirectional(this.episode.descriptionProperty());
        }
        this.episode = episode;
        if (episode == null) {
            this.lblTitle.setText("");
            this.lblGenre.setText("");
            this.lblDate.setText("");
            this.lblLength.setText("");
            this.size.setText("");
            this.hyperlinkWebsite.setUrl("");
            this.taDescription.setText("");
            return;
        }
        this.lblTitle.setText(episode.getEpisodeTitle());
        this.lblGenre.setText(episode.getGenre());
        this.lblDate.setText(P2LDateFactory.toString(episode.getPubDate()));
        this.lblLength.setText(episode.getDurationStr());
        this.size.setText(episode.getPFileSize().getSizeStr());
        this.hyperlinkWebsite.setUrl(episode.getEpisodeWebsite());
        this.taDescription.textProperty().bindBidirectional(episode.descriptionProperty());
    }
}

