/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui;

import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2Hyperlink;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class PaneDownloadInfo
extends VBox {
    private final Label lblTitle_ = new Label("Titel:");
    private final Label lblTitle = new Label("");
    private final Label lblDate = new Label("");
    private final Label lblLength = new Label("");
    private final Label lblSize = new Label("");
    private final P2Hyperlink hyperlinkWebsite = new P2Hyperlink("", ProgConfig.SYSTEM_PROG_OPEN_URL);
    private final P2Hyperlink hyperlinkUrl = new P2Hyperlink("", ProgConfig.SYSTEM_PROG_OPEN_URL);
    private final Label lblDescription = new Label("Beschreibung: ");
    private final TextArea taDescription = new TextArea();
    private DownloadData downloadData = null;

    public PaneDownloadInfo() {
        this.initInfo();
        VBox.setVgrow(this, Priority.ALWAYS);
    }

    public void initInfo() {
        GridPane gridPaneRight = new GridPane();
        GridPane gridPaneLeft = new GridPane();
        SplitPane splitPane = new SplitPane();
        splitPane.getItems().addAll((Node[])new Node[]{gridPaneLeft, gridPaneRight});
        ((SplitPane.Divider)splitPane.getDividers().get(0)).positionProperty().bindBidirectional(ProgConfig.DOWNLOAD_GUI_INFO_DIVIDER);
        VBox.setVgrow(splitPane, Priority.ALWAYS);
        this.getChildren().add(splitPane);
        this.lblTitle.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        this.taDescription.setEditable(true);
        this.taDescription.setWrapText(true);
        this.taDescription.setPrefRowCount(2);
        gridPaneLeft.setHgap(5.0);
        gridPaneLeft.setVgap(5.0);
        gridPaneLeft.setPadding(new Insets(10.0));
        gridPaneLeft.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        int row = 0;
        gridPaneLeft.add(this.lblTitle_, 0, row);
        gridPaneLeft.add(this.lblTitle, 1, row);
        gridPaneLeft.add(new Label("Website:"), 0, ++row);
        gridPaneLeft.add(this.hyperlinkWebsite, 1, row);
        gridPaneLeft.add(new Label("Download-URL:"), 0, ++row);
        gridPaneLeft.add(this.hyperlinkUrl, 1, row);
        gridPaneLeft.add(this.lblDescription, 0, ++row);
        gridPaneLeft.add(this.taDescription, 1, row);
        GridPane.setVgrow(this.taDescription, Priority.ALWAYS);
        gridPaneRight.setHgap(5.0);
        gridPaneRight.setVgap(5.0);
        gridPaneRight.setPadding(new Insets(10.0));
        gridPaneRight.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        row = 0;
        gridPaneRight.add(new Label("Datum:"), 0, row);
        gridPaneRight.add(this.lblDate, 1, row);
        gridPaneRight.add(new Label("Dauer:"), 0, ++row);
        gridPaneRight.add(this.lblLength, 1, row);
        gridPaneRight.add(new Label("Gr\u00f6\u00dfe:"), 0, ++row);
        gridPaneRight.add(this.lblSize, 1, row);
    }

    public void setDownload(DownloadData down) {
        if (this.downloadData != null) {
            this.taDescription.textProperty().unbindBidirectional(this.downloadData.descriptionProperty());
        }
        this.downloadData = down;
        if (this.downloadData == null) {
            this.lblTitle.setText("");
            this.lblDate.setText("");
            this.lblLength.setText("");
            this.lblSize.setText("");
            this.hyperlinkWebsite.setUrl("");
            this.hyperlinkUrl.setUrl("");
            this.taDescription.setText("");
            return;
        }
        this.lblTitle.setText(this.downloadData.getEpisodeTitle() + "  -  " + this.downloadData.getGenre());
        this.lblDate.setText(P2LDateFactory.toString(this.downloadData.getPubDate()));
        this.lblLength.setText(this.downloadData.getDurationStr());
        this.lblSize.setText(this.downloadData.getDownloadSize().toString());
        this.hyperlinkWebsite.setUrl(this.downloadData.getEpisodeWebsite());
        this.hyperlinkUrl.setUrl(this.downloadData.getEpisodeUrl());
        this.taDescription.textProperty().bindBidirectional(this.downloadData.descriptionProperty());
    }
}

