/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui;

import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import de.p2tools.p2podder.controller.data.download.DownloadFactory;
import de.p2tools.p2podder.controller.data.download.DownloadListStartStopFactory;
import de.p2tools.p2podder.gui.ToolBarButton;
import java.util.ArrayList;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;

public class DownloadMenu {
    private final VBox vBox;
    private final ProgData progData;

    public DownloadMenu(VBox vBox) {
        this.vBox = vBox;
        this.progData = ProgData.getInstance();
    }

    public void init() {
        this.vBox.getChildren().clear();
        this.initMenu();
        this.initButton();
    }

    private void initButton() {
        VBox vBoxSpace = new VBox();
        vBoxSpace.setMaxHeight(0.0);
        vBoxSpace.setMinHeight(0.0);
        this.vBox.getChildren().add(vBoxSpace);
        ToolBarButton btStart = new ToolBarButton(this.vBox, "Markierte Downloads starten", "Markierten Download starten", ProgIcons.ICON_TOOLBAR_DOWNLOAD_START.getImageView());
        ToolBarButton btStartAll = new ToolBarButton(this.vBox, "Alle Downloads starten", "Alle Downloads starten", ProgIcons.ICON_TOOLBAR_DOWNLOAD_START_ALL.getImageView());
        ToolBarButton btStop = new ToolBarButton(this.vBox, "Alle laufenden Downloads stoppen", "Alle laufenden Downloads stoppen", ProgIcons.ICON_TOOLBAR_STOP.getImageView());
        ToolBarButton btBack = new ToolBarButton(this.vBox, "Markierte Downloads zur\u00fcckstellen", "Markierte Downloads zur\u00fcckstellen", ProgIcons.ICON_TOOLBAR_DOWNLOAD_UNDO.getImageView());
        ToolBarButton btDel = new ToolBarButton(this.vBox, "Markierten Download l\u00f6schen", "Markierten Download l\u00f6schen", ProgIcons.ICON_TOOLBAR_DEL.getImageView());
        ToolBarButton btDownloadClear = new ToolBarButton(this.vBox, "Downloads aufr\u00e4umen", "Liste der Downloads aufr\u00e4umen", ProgIcons.ICON_TOOLBAR_DOWNLOAD_CLEAN.getImageView());
        ToolBarButton btInfo = new ToolBarButton(this.vBox, "Info-Dialog anzeigen", "Info-Dialog anzeigen", ProgIcons.ICON_TOOLBAR_INFO.getImageView());
        btStart.setOnAction(a -> {
            ArrayList<DownloadData> downloadList = this.progData.downloadGui.getDownloadGuiController().getSelList();
            if (!downloadList.isEmpty()) {
                this.progData.downloadList.startDownloads(downloadList, false);
            }
        });
        btStartAll.setOnAction(a -> DownloadFactory.startAllDownloads());
        btStop.setOnAction(a -> this.progData.downloadList.stopAllDownloads());
        btBack.setOnAction(a -> DownloadListStartStopFactory.putBackDownloads());
        btDel.setOnAction(a -> {
            ArrayList<DownloadData> optionalDownload = this.progData.downloadGui.getDownloadGuiController().getSelList();
            if (!optionalDownload.isEmpty()) {
                DownloadListStartStopFactory.delDownloads(optionalDownload);
            }
        });
        btDownloadClear.setOnAction(a -> DownloadFactory.cleanUpList());
        btInfo.setOnAction(a -> this.progData.downloadGui.getDownloadGuiController().showDownloadInfoDialog());
    }

    private void initMenu() {
        MenuButton mb = new MenuButton("");
        mb.setTooltip(new Tooltip("Download-Men\u00fc anzeigen"));
        mb.setGraphic(ProgIcons.ICON_TOOLBAR_MENU.getImageView());
        mb.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-0"});
        MenuItem miDownloadStart = new MenuItem("Download starten");
        miDownloadStart.setOnAction(a -> this.progData.downloadGui.getDownloadGuiController().startDownload());
        MenuItem miDownloadStop = new MenuItem("Download stoppen");
        miDownloadStop.setOnAction(a -> this.progData.downloadGui.getDownloadGuiController().stopDownload(false));
        MenuItem miStopAll = new MenuItem("Alle laufenden Download stoppen");
        miStopAll.setOnAction(a -> this.progData.downloadGui.getDownloadGuiController().stopDownload(true));
        MenuItem miDownloadChange = new MenuItem("Download \u00e4ndern");
        miDownloadChange.setOnAction(a -> this.progData.downloadGui.getDownloadGuiController().showDownloadInfoDialog());
        MenuItem miDownloadDel = new MenuItem("Download l\u00f6schen");
        miDownloadDel.setOnAction(a -> this.progData.downloadGui.getDownloadGuiController().deleteDownloads(false));
        MenuItem miDownloadDelAll = new MenuItem("Alle Downloads l\u00f6schen");
        miDownloadDelAll.setOnAction(a -> this.progData.downloadGui.getDownloadGuiController().deleteDownloads(true));
        MenuItem miStationInfo = new MenuItem("Download-Infos anzeigen");
        miStationInfo.setOnAction(a -> ProgConfig.DOWNLOAD__INFO_IS_SHOWING.setValue(!ProgConfig.DOWNLOAD__INFO_IS_SHOWING.get()));
        MenuItem miCopyUrl = new MenuItem("Download-URL kopieren");
        miCopyUrl.setOnAction(a -> this.progData.downloadGui.getDownloadGuiController().copyUrl());
        MenuItem miCleanDownloadDir = new MenuItem("Downloadverzeichnis aufr\u00e4umen");
        miCleanDownloadDir.setOnAction(a -> DownloadFactory.cleanUpDownloadDir());
        CheckMenuItem miShowFilter = new CheckMenuItem("Filter anzeigen");
        miShowFilter.disableProperty().bind(ProgConfig.DOWNLOAD__FILTER_IS_RIP);
        miShowFilter.selectedProperty().bindBidirectional(ProgConfig.DOWNLOAD__FILTER_IS_SHOWING);
        CheckMenuItem miShowInfo = new CheckMenuItem("Infos anzeigen");
        miShowInfo.disableProperty().bind(ProgConfig.DOWNLOAD__PANE_INFO_IS_RIP);
        miShowInfo.selectedProperty().bindBidirectional(ProgConfig.DOWNLOAD__INFO_IS_SHOWING);
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miDownloadStart, miDownloadStop, miStopAll, miDownloadChange, miDownloadDel, miDownloadDelAll, miCopyUrl, miCleanDownloadDir});
        mb.getItems().add(new SeparatorMenuItem());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miShowFilter, miShowInfo});
        this.vBox.getChildren().add(mb);
    }
}

