/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui;

import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2RowMoveFactory;
import de.p2tools.p2lib.guitools.P2TableFactory;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneController;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneDto;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneFactory;
import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.P2ToolsFactory;
import de.p2tools.p2podder.controller.config.PEvents;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import de.p2tools.p2podder.controller.data.download.DownloadListStartStopFactory;
import de.p2tools.p2podder.gui.DownloadGuiTableContextMenu;
import de.p2tools.p2podder.gui.PaneDownloadInfo;
import de.p2tools.p2podder.gui.dialog.DownloadInfoDialog;
import de.p2tools.p2podder.gui.tools.table.Table;
import de.p2tools.p2podder.gui.tools.table.TableDownload;
import de.p2tools.p2podder.gui.tools.table.TableRowDownload;
import java.util.ArrayList;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class DownloadGuiController
extends AnchorPane {
    private final SplitPane splitPane = new SplitPane();
    private final VBox vBox = new VBox(0.0);
    private final TableDownload tableView;
    private final RadioButton rbAll = new RadioButton("Alle");
    private final RadioButton rbStarted = new RadioButton("Gestartet");
    private final RadioButton rbLoading = new RadioButton("L\u00e4dt");
    private final RadioButton rbFinalized = new RadioButton("Abgeschlossen");
    private final P2ClosePaneController infoController;
    private final PaneDownloadInfo paneDownloadInfo;
    private final ProgData progData;
    private final BooleanProperty bound = new SimpleBooleanProperty(false);

    public DownloadGuiController() {
        this.progData = ProgData.getInstance();
        this.tableView = new TableDownload(Table.TABLE_ENUM.DOWNLOAD, this.progData);
        AnchorPane.setLeftAnchor(this.splitPane, 0.0);
        AnchorPane.setBottomAnchor(this.splitPane, 0.0);
        AnchorPane.setRightAnchor(this.splitPane, 0.0);
        AnchorPane.setTopAnchor(this.splitPane, 0.0);
        this.splitPane.setOrientation(Orientation.VERTICAL);
        this.getChildren().addAll((Node[])new Node[]{this.splitPane});
        ToggleGroup tg = new ToggleGroup();
        this.rbAll.setToggleGroup(tg);
        this.rbStarted.setToggleGroup(tg);
        this.rbLoading.setToggleGroup(tg);
        this.rbFinalized.setToggleGroup(tg);
        HBox hBoxFilter = new HBox();
        hBoxFilter.setPadding(new Insets(5.0));
        hBoxFilter.setSpacing(15.0);
        hBoxFilter.getChildren().addAll((Node[])new Node[]{new Label("Downloads: "), this.rbAll, this.rbStarted, this.rbLoading, this.rbFinalized});
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        scrollPane.setContent(this.tableView);
        this.vBox.getChildren().addAll((Node[])new Node[]{scrollPane, hBoxFilter});
        VBox.setVgrow(scrollPane, Priority.ALWAYS);
        this.paneDownloadInfo = new PaneDownloadInfo();
        P2ClosePaneDto infoDto = new P2ClosePaneDto(this.paneDownloadInfo, ProgConfig.DOWNLOAD__PANE_INFO_IS_RIP, ProgConfig.DOWNLOAD__DIALOG_INFO_SIZE, ProgData.DOWNLOAD_TAB_ON, "Info", "Beschreibung", false);
        this.infoController = new P2ClosePaneController(infoDto, ProgConfig.DOWNLOAD__INFO_IS_SHOWING);
        ProgConfig.DOWNLOAD__INFO_IS_SHOWING.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        ProgConfig.DOWNLOAD__PANE_INFO_IS_RIP.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        this.setInfoPane();
        this.initFilter();
        this.initTable();
        this.initListener();
    }

    public void tableRefresh() {
        this.tableView.refresh();
    }

    public void isShown() {
        this.tableView.requestFocus();
        this.setSelectedDownload();
    }

    public int getDownloadsShown() {
        return this.tableView.getItems().size();
    }

    public void copyUrl() {
        Optional<DownloadData> download = this.getSel();
        if (download.isEmpty()) {
            return;
        }
        P2ToolsFactory.copyToClipboard(download.get().getEpisodeUrl());
    }

    private void setSelectedDownload() {
        DownloadData download = (DownloadData)this.tableView.getSelectionModel().getSelectedItem();
        this.paneDownloadInfo.setDownload(download);
    }

    public void startDownload() {
        Optional<DownloadData> download = this.getSel();
        download.ifPresent(downloadData -> this.progData.downloadList.startDownloads((DownloadData)downloadData));
    }

    public void stopDownload(boolean all) {
        if (all) {
            this.progData.downloadList.forEach(DownloadData::stopDownload);
        } else {
            Optional<DownloadData> download = this.getSel();
            download.ifPresent(DownloadData::stopDownload);
        }
    }

    public void deleteDownloads(boolean all) {
        if (all) {
            ArrayList<DownloadData> list = this.getSelList();
            if (list.isEmpty()) {
                return;
            }
            String text = list.size() == 1 ? "Soll der Download gel\u00f6scht werden?" : "Sollen die Downloads gel\u00f6scht werden?";
            if (P2Alert.showAlert_yes_no(ProgData.getInstance().primaryStage, "Downloads l\u00f6schen?", "Downloads l\u00f6schen?", text).equals((Object)P2Alert.BUTTON.YES)) {
                DownloadListStartStopFactory.delDownloads(list);
            }
        } else {
            Optional<DownloadData> download = this.getSel();
            download.ifPresent(this::deleteDownloads);
        }
    }

    public void deleteDownloads(DownloadData download) {
        if (P2Alert.showAlert_yes_no(ProgData.getInstance().primaryStage, "Download l\u00f6schen?", "Download l\u00f6schen?", "Soll der Download gel\u00f6scht werden?").equals((Object)P2Alert.BUTTON.YES)) {
            DownloadListStartStopFactory.delDownloads(download);
        }
    }

    public void showDownloadInfoDialog() {
        Optional<DownloadData> download = this.getSel();
        download.ifPresent(downloadData -> new DownloadInfoDialog(this.progData, (DownloadData)downloadData));
    }

    public void saveTable() {
        Table.saveTable(this.tableView, Table.TABLE_ENUM.DOWNLOAD);
    }

    public ArrayList<DownloadData> getSelList() {
        ArrayList<DownloadData> ret = new ArrayList<DownloadData>(this.tableView.getSelectionModel().getSelectedItems());
        if (ret.isEmpty()) {
            P2Alert.showInfoNoSelection();
        }
        return ret;
    }

    public Optional<DownloadData> getSel() {
        return this.getSel(true);
    }

    public Optional<DownloadData> getSel(boolean show) {
        int selectedTableRow = this.tableView.getSelectionModel().getSelectedIndex();
        if (selectedTableRow >= 0) {
            return Optional.of((DownloadData)this.tableView.getSelectionModel().getSelectedItem());
        }
        if (show) {
            P2Alert.showInfoNoSelection();
        }
        return Optional.empty();
    }

    private void initListener() {
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_SETDATA_CHANGED){

            public void pingGui(P2Event runEvent) {
                P2TableFactory.refreshTable(DownloadGuiController.this.tableView);
            }
        });
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_REFRESH_TABLE){

            public void pingGui(P2Event runEvent) {
                P2TableFactory.refreshTable(DownloadGuiController.this.tableView);
            }
        });
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_DOWNLOAD_REFRESH_TABLE){

            public void pingGui(P2Event runEvent) {
                P2TableFactory.refreshTable(DownloadGuiController.this.tableView);
            }
        });
    }

    private void setInfoPane() {
        P2ClosePaneFactory.setSplit(this.bound, this.splitPane, this.infoController, false, this.vBox, ProgConfig.DOWNLOAD__INFO_DIVIDER, ProgConfig.DOWNLOAD__INFO_IS_SHOWING);
    }

    private void initFilter() {
        this.rbAll.selectedProperty().bindBidirectional(this.progData.downloadFilter.isAllProperty());
        this.rbStarted.selectedProperty().bindBidirectional(this.progData.downloadFilter.isStartedProperty());
        this.rbLoading.selectedProperty().bindBidirectional(this.progData.downloadFilter.isLoadingProperty());
        this.rbFinalized.selectedProperty().bindBidirectional(this.progData.downloadFilter.isFinalizedProperty());
    }

    private void initTable() {
        Table.setTable(this.tableView);
        this.tableView.setItems(this.progData.downloadList.getSortedList());
        this.progData.downloadList.getSortedList().comparatorProperty().bind(this.tableView.comparatorProperty());
        this.tableView.setOnMouseClicked(m -> {
            if (m.getButton().equals((Object)MouseButton.PRIMARY) && m.getClickCount() == 2) {
                this.showDownloadInfoDialog();
            }
        });
        this.tableView.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                Optional<DownloadData> optionalDownload = this.getSel(false);
                DownloadData download = optionalDownload.orElse(null);
                ContextMenu contextMenu = new DownloadGuiTableContextMenu(this.progData, this, this.tableView).getContextMenu(download);
                this.tableView.setContextMenu(contextMenu);
            }
        });
        this.tableView.setRowFactory(new P2RowMoveFactory(tv -> {
            TableRowDownload row = new TableRowDownload();
            row.hoverProperty().addListener(observable2 -> {
                DownloadData download = (DownloadData)row.getItem();
                if (row.isHover() && download != null) {
                    this.paneDownloadInfo.setDownload(download);
                } else {
                    this.setSelectedDownload();
                }
            });
            return row;
        }));
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> this.setSelectedDownload());
        this.tableView.addEventFilter(KeyEvent.KEY_PRESSED, (? super T event) -> {
            if (P2TableFactory.SPACE.match((KeyEvent)event)) {
                P2TableFactory.scrollVisibleRangeDown(this.tableView);
                event.consume();
            }
            if (P2TableFactory.SPACE_SHIFT.match((KeyEvent)event)) {
                P2TableFactory.scrollVisibleRangeUp(this.tableView);
                event.consume();
            }
        });
    }
}

