/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.worker;

import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2podder.controller.config.PEvents;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.episode.Episode;

public class EpisodeInfos {
    private int amount = 0;
    private int notStarted = 0;
    private int started = 0;
    private boolean search = false;
    private final ProgData progData;

    public EpisodeInfos(ProgData progData) {
        this.progData = progData;
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_TIMER_SECOND){

            public void ping(P2Event event) {
                EpisodeInfos.this.generateEpisodeInfos();
            }
        });
    }

    public synchronized int getAmount() {
        return this.amount;
    }

    public int getNotStarted() {
        return this.notStarted;
    }

    public synchronized int getStarted() {
        return this.started;
    }

    private synchronized void generateEpisodeInfos() {
        boolean bl = this.search = !this.search;
        if (!this.search) {
            return;
        }
        P2Duration.counterStart("generateInfos");
        this.clean();
        for (Episode episode : this.progData.episodeList) {
            ++this.amount;
            if (episode.getStart() != null) {
                ++this.started;
                continue;
            }
            ++this.notStarted;
        }
        P2Duration.counterStop("generateInfos");
    }

    private synchronized void clean() {
        this.amount = 0;
        this.notStarted = 0;
        this.started = 0;
    }
}

