/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.starterdownload;

import de.p2tools.p2lib.mediathek.tools.P2SizeTools;
import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.tools.date.P2Date;
import de.p2tools.p2lib.tools.date.P2DateConst;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.ProgQuitFactory;
import de.p2tools.p2podder.controller.config.PEvents;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import de.p2tools.p2podder.controller.data.download.DownloadFactory;
import de.p2tools.p2podder.controller.data.download.DownloadListStartFactory;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.controller.starterdownload.DirectHttpDownload;
import de.p2tools.p2podder.controller.starterdownload.DownloadStart;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Timer;
import javafx.application.Platform;

public class DownloadStarterFactory {
    private final ProgData progData;
    private StarterThread starterThread = null;
    private boolean paused = false;

    public DownloadStarterFactory(ProgData progData) {
        this.progData = progData;
    }

    public void startWaitingDownloads() {
        if (this.starterThread == null || !this.starterThread.isAlive()) {
            this.starterThread = new StarterThread();
            this.starterThread.start();
        }
    }

    public void setPaused() {
        this.paused = true;
    }

    static boolean check(ProgData progData, DownloadData download) {
        boolean ret = false;
        double progress = download.getProgress();
        if (progress > -1.0 && progress < 0.995) {
            P2Log.errorLog(696510258, "Download fehlgeschlagen: 99,5% wurden nicht erreicht: " + progress + "%, " + download.getDestPathFile());
            return false;
        }
        File file = new File(download.getDestPathFile());
        if (!file.exists()) {
            P2Log.errorLog(550236231, "Download fehlgeschlagen: Datei existiert nicht: " + download.getDestPathFile());
        } else if (file.length() < 256000L) {
            P2Log.errorLog(457892323, "Download fehlgeschlagen: Datei zu klein: " + download.getDestPathFile());
        } else {
            progData.historyDownloads.addHistoryDataToHistory(download);
            ret = true;
        }
        return ret;
    }

    static void deleteIfEmpty(File file) {
        try {
            if (file.exists()) {
                if (file.length() == 0L) {
                    P2Log.sysLog(new String[]{"Restart/Aufr\u00e4umen: leere Datei l\u00f6schen", file.getAbsolutePath()});
                    if (!file.delete()) {
                        throw new Exception();
                    }
                } else if (file.length() < 256000L) {
                    P2Log.sysLog(new String[]{"Restart/Aufr\u00e4umen: Zu kleine Datei l\u00f6schen", file.getAbsolutePath()});
                    if (!file.delete()) {
                        throw new Exception();
                    }
                }
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(768123400, "Fehler beim l\u00f6schen" + file.getAbsolutePath());
        }
    }

    static void startMsg(DownloadData download) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("------------------------------------------------------------");
        list.add("Download starten");
        list.add("Ziel: " + download.getDestPathFile());
        list.add("URL: " + download.getEpisodeUrl());
        list.add("Startzeit: " + P2DateConst.F_FORMAT_HH__mm__ss.format(download.getDownloadStart().getStartTime()));
        list.add("  ");
        P2Log.sysLog(list.toArray(new String[list.size()]));
    }

    private void restartMsg(DownloadData download) {
        ArrayList<CallSite> text = new ArrayList<CallSite>();
        text.add((CallSite)((Object)("Fehlerhaften Download neu starten - Restart (Summe Starts: " + download.getDownloadStart().getRestartCounter() + ")")));
        text.add((CallSite)((Object)("Ziel: " + download.getDestPathFile())));
        text.add((CallSite)((Object)("URL: " + download.getEpisodeUrl())));
        P2Log.sysLog(text.toArray(new String[text.size()]));
    }

    private static void finishedMsg(DownloadData download) {
        long dauer;
        DownloadStart start = download.getDownloadStart();
        ArrayList<String> list = new ArrayList<String>();
        list.add("------------------------------------------------------------");
        if (download.isStateStopped()) {
            list.add("Download wurde abgebrochen");
        } else {
            if (download.isStateFinished()) {
                list.add("Download ist fertig und hat geklappt");
            } else if (download.isStateError()) {
                list.add("Download ist fertig und war fehlerhaft");
            }
            list.add("Ziel: " + download.getDestPathFile());
        }
        list.add("Startzeit: " + P2DateConst.F_FORMAT_HH__mm__ss.format(download.getDownloadStart().getStartTime()));
        list.add("Endzeit: " + P2DateConst.F_FORMAT_HH__mm__ss.format(new P2Date().getTime()));
        if (start.getRestartCounter() > 0) {
            list.add("Restarts: " + start.getRestartCounter());
        }
        if ((dauer = (long)download.getDownloadStart().getStartTime().diffInMinutes()) == 0L) {
            list.add("Dauer: " + download.getDownloadStart().getStartTime().diffInSeconds() + " s");
        } else {
            list.add("Dauer: " + download.getDownloadStart().getStartTime().diffInMinutes() + " Min");
        }
        if (download.getDownloadStart().getInputStream() != null) {
            list.add("Bytes gelesen: " + P2SizeTools.humanReadableByteCount(download.getDownloadStart().getInputStream().getSumByte(), true));
            list.add("Bandbreite: " + P2SizeTools.humanReadableByteCount(download.getDownloadStart().getInputStream().getSumBandwidth(), true));
        }
        list.add("URL: " + download.getEpisodeUrl());
        list.add("  ");
        P2Log.sysLog(list);
    }

    static void finalizeDownload(DownloadData download) {
        DownloadStart start = download.getDownloadStart();
        DownloadStarterFactory.deleteIfEmpty(new File(download.getDestPathFile()));
        DownloadStarterFactory.setFileSize(download);
        DownloadStarterFactory.finishedMsg(download);
        if (download.isStateError()) {
            download.setProgress(-1.0);
        } else if (!download.isStateStopped()) {
            long dauer;
            start.setTimeLeftSeconds(0L);
            download.setProgress(1.0);
            download.getDownloadSize().setActuallySize(-1L);
            if (start.getInputStream() != null) {
                download.setBandwidth("\u00d8 " + P2SizeTools.humanReadableByteCount(start.getInputStream().getSumBandwidth(), true));
            }
            if ((dauer = (long)start.getStartTime().diffInMinutes()) == 0L) {
                download.setRemaining("Dauer: " + start.getStartTime().diffInSeconds() + " s");
            } else {
                download.setRemaining("Dauer: " + start.getStartTime().diffInMinutes() + " Min");
            }
            Episode episode = new Episode(download);
            Platform.runLater(() -> ProgData.getInstance().episodeList.add(episode));
        }
        Platform.runLater(() -> ProgData.getInstance().pEventHandler.notifyListener(new P2Event(PEvents.EVENT_DOWNLOAD_REFRESH_TABLE)));
        start.setProcess(null);
        start.setInputStream(null);
        start.setStartTime(null);
    }

    static void setFileSize(DownloadData download) {
        try {
            long length;
            File destFile = new File(download.getDestPathFile());
            if (destFile.exists() && (length = destFile.length()) > 0L) {
                download.getDownloadSize().setActuallySize(length);
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(461204780, "Fehler beim Ermitteln der Dateigr\u00f6\u00dfe: " + download.getDestPathFile());
        }
    }

    private class StarterThread
    extends Thread {
        private DownloadData download;
        private final Timer bandwidthCalculationTimer;

        public StarterThread() {
            this.setName("DownloadStarter Daemon Thread");
            this.setDaemon(true);
            this.bandwidthCalculationTimer = new Timer("BandwidthCalculationTimer");
        }

        @Override
        public synchronized void run() {
            try {
                while (DownloadFactory.getDownloadsWaiting() > 0L) {
                    while ((this.download = this.getNextStart()) != null) {
                        this.startDownload(this.download);
                        StarterThread.sleep(2000L);
                    }
                    StarterThread.sleep(5000L);
                }
                if (ProgData.auto) {
                    while (DownloadFactory.getDownloadsSaving() > 0L) {
                        StarterThread.sleep(2000L);
                    }
                    ProgQuitFactory.quit();
                }
            }
            catch (Exception ex) {
                P2Log.errorLog(201201478, ex);
            }
        }

        private synchronized DownloadData getNextStart() throws InterruptedException {
            DownloadData download;
            if (DownloadStarterFactory.this.paused) {
                StarterThread.sleep(5000L);
                DownloadStarterFactory.this.paused = false;
            }
            if ((download = DownloadListStartFactory.getNextStart()) == null && (download = DownloadListStartFactory.getRestartDownload()) != null) {
                DownloadStarterFactory.this.restartMsg(download);
            }
            return download;
        }

        private void startDownload(DownloadData download) {
            download.getDownloadStart().startDownload();
            DirectHttpDownload downloadThread = new DirectHttpDownload(DownloadStarterFactory.this.progData, download, this.bandwidthCalculationTimer);
            downloadThread.start();
        }
    }
}

