/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.history;

import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.history.HistoryData;
import de.p2tools.p2podder.controller.history.HistoryWorker;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import javafx.beans.property.BooleanProperty;

public class HistoryWriteToFile
implements Runnable {
    private final List<HistoryData> list;
    private final boolean append;
    private final BooleanProperty isWorking;
    private final HistoryWorker historyWorker;

    public HistoryWriteToFile(List<HistoryData> list, boolean append, BooleanProperty isWorking, HistoryWorker historyWorker) {
        this.list = list;
        this.append = append;
        this.isWorking = isWorking;
        this.historyWorker = historyWorker;
    }

    @Override
    public void run() {
        this.doWork();
        this.isWorking.setValue(false);
    }

    private void doWork() {
        Path urlPath = this.historyWorker.getUrlFilePath();
        if (Files.notExists(urlPath, new LinkOption[0])) {
            return;
        }
        P2Duration.counterStart("History: Thread: HistoryWriteToFile");
        if (this.append) {
            P2Log.sysLog("An Historyliste anf\u00fcgen: " + this.list.size() + ", Datei: " + this.historyWorker.getFileName());
        } else {
            P2Log.sysLog("Ganze Historyliste schreiben: " + this.list.size() + ", Datei: " + this.historyWorker.getFileName());
        }
        this.writeHistoryDataToFile(this.list, this.append);
        P2Duration.counterStop("History: Thread: HistoryWriteToFile");
    }

    private boolean writeHistoryDataToFile(List<HistoryData> list, boolean append) {
        boolean ret = false;
        try (BufferedWriter bufferedWriter = append ? new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.historyWorker.getUrlFilePath(), StandardOpenOption.APPEND))) : new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.historyWorker.getUrlFilePath(), new OpenOption[0])));){
            for (HistoryData historyData : list) {
                String line = historyData.getLine();
                bufferedWriter.write(line);
            }
            ret = true;
        }
        catch (Exception ex) {
            P2Log.errorLog(420312459, ex);
        }
        return ret;
    }
}

