/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.history;

import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.history.HistoryData;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class HistoryWorker {
    private final String fileName;
    private final String settingsDir;
    static final String regEx1 = "[\\n\\r]";
    static final String regEx2 = "[\\p{Cc}&&[^\\t\\n\\r]]";

    public HistoryWorker(String fileName, String settingsDir) {
        this.fileName = fileName;
        this.settingsDir = settingsDir;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getSettingsDir() {
        return this.settingsDir;
    }

    synchronized void deleteHistoryFile() {
        try {
            Path urlPath = this.getUrlFilePath();
            Files.deleteIfExists(urlPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void readHistoryDataFromFile(List<HistoryData> dataList) {
        Path urlPath = this.getUrlFilePath();
        try (LineNumberReader in = new LineNumberReader(new InputStreamReader(Files.newInputStream(urlPath, new OpenOption[0])));){
            String line;
            while ((line = in.readLine()) != null) {
                HistoryData historyData = HistoryData.getHistoryDataFromLine(line);
                historyData.setTheme(HistoryWorker.cleanUnicode(historyData.getTheme()));
                historyData.setTitle(HistoryWorker.cleanUnicode(historyData.getTitle()));
                dataList.add(historyData);
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(926362547, ex);
        }
    }

    public static String cleanUnicode(String ret) {
        return HistoryWorker.clean_1(ret, true);
    }

    private static String clean_1(String ret, boolean alsoNewLine) {
        ret = alsoNewLine ? ret.replaceAll(regEx1, " ").replaceAll(regEx2, "") : ret.replaceAll(regEx2, "");
        return ret;
    }

    synchronized Path getUrlFilePath() {
        Path urlPath = null;
        try {
            urlPath = Paths.get(this.settingsDir, new String[0]).resolve(this.fileName);
            if (Files.notExists(urlPath, new LinkOption[0])) {
                urlPath = Files.createFile(urlPath, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            P2Log.errorLog(915478960, ex);
        }
        return urlPath;
    }
}

