/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.history;

import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.tools.date.P2DateConst;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.controller.history.HistoryData;
import de.p2tools.p2podder.controller.history.HistoryWorker;
import de.p2tools.p2podder.controller.history.HistoryWriteToFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.stage.Stage;

public class HistoryList
extends SimpleListProperty<HistoryData> {
    private final HashSet<String> urlHash = new HashSet();
    private final String fileName;
    private FilteredList<HistoryData> filteredList = null;
    private SortedList<HistoryData> sortedList = null;
    private BooleanProperty isWorking = new SimpleBooleanProperty(false);
    public final HistoryWorker historyWorker;
    private boolean found = false;

    public HistoryList(String fileName, String settingsDir) {
        super(FXCollections.observableArrayList());
        this.fileName = fileName;
        this.historyWorker = new HistoryWorker(fileName, settingsDir);
        this.historyWorker.readHistoryDataFromFile(this);
        this.fillUrlHash();
    }

    public SortedList<HistoryData> getSortedList() {
        this.filteredList = this.getFilteredList();
        if (this.sortedList == null) {
            this.sortedList = new SortedList<HistoryData>((ObservableList<HistoryData>)this.filteredList);
        }
        return this.sortedList;
    }

    public FilteredList<HistoryData> getFilteredList() {
        if (this.filteredList == null) {
            this.filteredList = new FilteredList<HistoryData>(this, p -> true);
        }
        return this.filteredList;
    }

    public synchronized void filteredListSetPredicate(Predicate<HistoryData> predicate) {
        this.filteredList.setPredicate(predicate);
    }

    public synchronized void filterdListSetPredFalse() {
        this.filteredList.setPredicate(p -> false);
    }

    public synchronized void filterdListSetPredTrue() {
        this.filteredList.setPredicate(p -> true);
    }

    public synchronized void clearAll(Stage stage) {
        int size = this.size();
        String title = "Filme";
        if (size <= 1 || P2Alert.showAlertOkCancel(stage, "L\u00f6schen", "Filme l\u00f6schen", "Soll die gesamte Liste (" + size + " Filme) gel\u00f6scht werden?")) {
            this.clearList();
            this.historyWorker.deleteHistoryFile();
        }
    }

    public synchronized boolean checkIfUrlAlreadyIn(String urlFilm) {
        return this.urlHash.contains(urlFilm);
    }

    public synchronized void addHistoryDataToHistory(DownloadData download) {
        this.addHistoryDataToHistory(download.getGenre(), download.getEpisodeTitle(), download.getEpisodeUrl());
    }

    public synchronized void addHistoryDataToHistory(Episode episode) {
        this.addHistoryDataToHistory(episode.getGenre(), episode.getEpisodeTitle(), episode.getEpisodeUrl());
    }

    private synchronized void addHistoryDataToHistory(String theme, String title, String url) {
        if (this.checkIfUrlAlreadyIn(url)) {
            return;
        }
        P2Duration.counterStart("History: addDataToHistory");
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        String datum = P2DateConst.F_FORMAT_dd_MM_yyyy.format(new Date());
        HistoryData historyData = new HistoryData(datum, theme, title, url);
        this.addToThisList(historyData);
        list.add(historyData);
        this.writeToFile(list, true);
        P2Duration.counterStop("History: addDataToHistory");
    }

    public synchronized void addDownloadDataListToHistory(ArrayList<DownloadData> downloadList) {
        if (downloadList == null || downloadList.isEmpty()) {
            return;
        }
        ArrayList<HistoryData> list = new ArrayList<HistoryData>(downloadList.size());
        String datum = P2DateConst.F_FORMAT_dd_MM_yyyy.format(new Date());
        P2Duration.counterStart("History: addDataToHistory");
        for (DownloadData download : downloadList) {
            if (this.checkIfUrlAlreadyIn(download.getEpisodeUrl())) continue;
            HistoryData historyData = new HistoryData(datum, download.getGenre(), download.getEpisodeTitle(), download.getEpisodeUrl());
            this.addToThisList(historyData);
            list.add(historyData);
        }
        this.writeToFile(list, true);
        P2Duration.counterStop("History: addDataToHistory");
    }

    private void writeToFile(List<HistoryData> list, boolean append) {
        this.waitWhileWorkingAndSetWorking();
        try {
            Thread th = new Thread(new HistoryWriteToFile(list, append, this.isWorking, this.historyWorker));
            th.setName("HistoryWriteToFile");
            th.start();
        }
        catch (Exception ex) {
            P2Log.errorLog(912030254, ex, "writeToFile");
            this.isWorking.setValue(false);
        }
    }

    private void waitWhileWorking() {
        while (this.isWorking.get()) {
            P2Log.errorLog(741025896, "waitWhileWorking: write to history file");
            try {
                this.wait(100L);
            }
            catch (Exception ex) {
                P2Log.errorLog(915236547, ex, "waitWhileWorking");
                this.isWorking.setValue(false);
            }
        }
    }

    private void waitWhileWorkingAndSetWorking() {
        this.waitWhileWorking();
        this.isWorking.setValue(true);
    }

    public synchronized void removeHistoryDataFromHistory(ArrayList<HistoryData> historyDataList) {
        if (historyDataList == null || historyDataList.isEmpty()) {
            return;
        }
        P2Duration.counterStart("History: removeDataFromHistory");
        HashSet<String> hash = new HashSet<String>(historyDataList.size() + 1, 0.75f);
        for (HistoryData historyData : historyDataList) {
            hash.add(historyData.getUrl());
        }
        this.removeFromHistory(hash);
        P2Duration.counterStop("History: removeDataFromHistory");
    }

    public synchronized void removeFilmDataFromHistory(ArrayList<DownloadData> filmList) {
        if (filmList == null || filmList.isEmpty()) {
            return;
        }
        P2Duration.counterStart("History: removeDataFromHistory");
        HashSet<String> hash = new HashSet<String>(filmList.size() + 1, 0.75f);
        filmList.stream().forEach(film -> hash.add(film.getEpisodeUrl()));
        this.removeFromHistory(hash);
        P2Duration.counterStop("History: removeDataFromHistory");
    }

    public synchronized void removeDownloadDataFromHistory(ArrayList<DownloadData> downloadList) {
        if (downloadList == null || downloadList.isEmpty()) {
            return;
        }
        P2Duration.counterStart("History: removeDataFromHistory");
        HashSet<String> hash = new HashSet<String>(downloadList.size() + 1, 0.75f);
        downloadList.stream().forEach(download -> hash.add(download.getEpisodeUrl()));
        this.removeFromHistory(hash);
        P2Duration.counterStop("History: removeDataFromHistory");
    }

    private void removeFromHistory(HashSet<String> urlHash) {
        ArrayList<HistoryData> newHistoryList = new ArrayList<HistoryData>();
        this.found = false;
        P2Duration.counterStart("History: removeFromHistory");
        P2Log.sysLog("Aus Historyliste l\u00f6schen: " + urlHash.size() + ", l\u00f6schen aus: " + this.fileName);
        this.waitWhileWorking();
        this.stream().forEach(historyData -> {
            if (urlHash.contains(historyData.getUrl())) {
                this.found = true;
            } else {
                newHistoryList.add((HistoryData)historyData);
            }
        });
        if (this.found) {
            this.replaceThisList(newHistoryList);
            this.writeToFile(newHistoryList, false);
        }
        P2Duration.counterStop("History: removeFromHistory");
    }

    private void clearList() {
        this.urlHash.clear();
        this.clear();
    }

    private void addToThisList(HistoryData historyData) {
        this.add(historyData);
        this.urlHash.add(historyData.getUrl());
    }

    private void replaceThisList(List<HistoryData> historyData) {
        this.clearList();
        this.addAll(historyData);
        this.fillUrlHash();
    }

    private void fillUrlHash() {
        this.urlHash.clear();
        this.stream().forEach(h -> this.urlHash.add(h.getUrl()));
    }
}

