/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.history;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.tools.GermanStringSorter;
import de.p2tools.p2lib.tools.P2StringUtils;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.gui.tools.DownloadDate;
import org.apache.commons.lang3.time.FastDateFormat;

public class HistoryData
implements Comparable<HistoryData> {
    private static final FastDateFormat sdf_datum = FastDateFormat.getInstance("dd.MM.yyyy");
    private static final GermanStringSorter sorter = GermanStringSorter.getInstance();
    private static final String SEPARATOR_1 = " |#| ";
    private static final String SEPARATOR_2 = "  |###|  ";
    public String title = "";
    public String theme = "";
    public String url = "";
    public DownloadDate date = new DownloadDate();

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String fName) {
        this.url = fName;
    }

    public DownloadDate getDate() {
        return this.date;
    }

    public void setDate(DownloadDate fName) {
        this.date = fName;
    }

    public HistoryData(String date, String theme, String title, String url) {
        this.setTitle(title);
        this.setTheme(theme);
        this.setUrl(url);
        try {
            this.setDate(new DownloadDate(sdf_datum.parse(date).getTime()));
        }
        catch (Exception ignore) {
            this.setDate(new DownloadDate(0L));
        }
    }

    public String getLine() {
        String dateStr = this.getDate().toString();
        String theme = this.getTheme();
        String title = this.getTitle();
        String url = this.getUrl();
        int MAX_THEME = 25;
        int MAX_TITLE = 40;
        if (dateStr.isEmpty() && theme.isEmpty() && title.isEmpty()) {
            return url + P2LibConst.LINE_SEPARATOR;
        }
        if (theme.length() < 25) {
            theme = P2StringUtils.shortenString(25, theme, false, false);
        }
        if (title.length() < 40) {
            title = P2StringUtils.shortenString(40, title, false, false);
        }
        return dateStr + SEPARATOR_1 + HistoryData.cleanUp(theme) + SEPARATOR_1 + HistoryData.cleanUp(title) + SEPARATOR_2 + url + P2LibConst.LINE_SEPARATOR;
    }

    public static HistoryData getHistoryDataFromLine(String line) {
        String url = "";
        String theme = "";
        String title = "";
        String date = "";
        try {
            if (line.contains(SEPARATOR_2)) {
                int a1 = line.lastIndexOf(SEPARATOR_2);
                url = line.substring(a1 += SEPARATOR_2.length()).trim();
                title = line.substring(line.lastIndexOf(SEPARATOR_1) + SEPARATOR_1.length(), line.lastIndexOf(SEPARATOR_2)).trim();
                date = line.substring(0, line.indexOf(SEPARATOR_1)).trim();
                theme = line.substring(line.indexOf(SEPARATOR_1) + SEPARATOR_1.length(), line.lastIndexOf(SEPARATOR_1)).trim();
            } else {
                url = line;
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(398853224, ex);
        }
        return new HistoryData(date, theme, title, url);
    }

    private static String cleanUp(String s) {
        s = s.replace("\n", "");
        s = s.replace("\r\n", "");
        s = s.replace(P2LibConst.LINE_SEPARATOR, "");
        s = s.replace("|", "");
        s = s.replace(SEPARATOR_1, "");
        s = s.replace(SEPARATOR_2, "");
        return s;
    }

    @Override
    public int compareTo(HistoryData arg0) {
        return sorter.compare(this.getTitle(), arg0.getTitle());
    }
}

