/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.data.episode;

import de.p2tools.p2lib.configfile.pdata.P2DataList;
import de.p2tools.p2lib.tools.GermanStringSorter;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.controller.data.episode.EpisodeStartsFactory;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;

public class EpisodeList
extends SimpleListProperty<Episode>
implements P2DataList<Episode> {
    public static final String TAG = "episodeList:EpisodeList";
    private final ProgData progData;
    private final EpisodeStartsFactory episodeStartsFactory;
    private int no = 0;
    private final FilteredList<Episode> filteredList;
    private final SortedList<Episode> sortedList;
    private final FilteredList<Episode> smallFilteredList;
    private final SortedList<Episode> smallSortedList;
    private final BooleanProperty episodeChanged = new SimpleBooleanProperty(true);
    private final ObservableList<Podcast> podcastList = FXCollections.observableArrayList();
    private final ObservableList<String> genreList = FXCollections.observableArrayList();

    public EpisodeList(ProgData progData) {
        super(FXCollections.observableArrayList());
        this.progData = progData;
        this.episodeStartsFactory = new EpisodeStartsFactory(progData, this);
        this.filteredList = new FilteredList<Episode>(this, p -> true);
        this.sortedList = new SortedList<Episode>((ObservableList<Episode>)this.filteredList);
        this.smallFilteredList = new FilteredList<Episode>(this, p -> true);
        this.smallSortedList = new SortedList<Episode>((ObservableList<Episode>)this.smallFilteredList);
    }

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public String getComment() {
        return "Liste aller Episoden";
    }

    @Override
    public Episode getNewItem() {
        return new Episode();
    }

    @Override
    public void addNewItem(Object obj) {
        if (obj.getClass().equals(Episode.class)) {
            this.add((Episode)obj);
        }
    }

    public synchronized void initList() {
        P2Duration.counterStart("initList");
        for (Episode episode : this) {
            episode.setThePodcast(this.progData.podcastList.getPodcastById(episode.getPodcastId()));
        }
        this.countEpisodes();
        this.genGenreList();
        this.genPodcastList();
        this.addListener((ObservableValue<? super ObservableList<E>> v, ? super ObservableList<E> o, ? super ObservableList<E> n) -> {
            this.genGenreList();
            this.genPodcastList();
        });
        P2Duration.counterStop("initList");
    }

    public SortedList<Episode> getSortedList() {
        return this.sortedList;
    }

    public SortedList<Episode> getSmallSortedList() {
        return this.smallSortedList;
    }

    public synchronized void filteredListSetPred(Predicate<Episode> predicate) {
        this.filteredList.setPredicate(predicate);
    }

    public synchronized void smallFilteredListSetPred(Predicate<Episode> predicate) {
        this.smallFilteredList.setPredicate(predicate);
    }

    public void sort() {
        Collections.sort(this);
    }

    public synchronized Episode getNextStart() {
        if (this.isEmpty()) {
            return null;
        }
        return (Episode)this.remove(0);
    }

    @Override
    public synchronized boolean add(Episode d) {
        d.setNo(++this.no);
        return super.add(d);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends Episode> elements) {
        elements.stream().forEach(f -> f.setNo(++this.no));
        return super.addAll(elements);
    }

    public synchronized boolean addAll(Episode ... var1) {
        for (Episode f : var1) {
            f.setNo(++this.no);
        }
        return super.addAll(var1);
    }

    public synchronized void countEpisodes() {
        this.progData.podcastList.stream().forEach(p -> p.setAmountEpisodes(0));
        this.stream().forEach(e -> {
            Podcast p = this.progData.podcastList.getPodcastById(e.getPodcastId());
            if (p != null) {
                p.setAmountEpisodes(p.getAmountEpisodes() + 1);
            }
        });
    }

    public synchronized int countStartedAndRunningEpisode() {
        int ret = 0;
        for (Episode episode : this) {
            if (episode.getStart() == null || !episode.getStart().getStartStatus().isStarted() && !episode.getStart().getStartStatus().isStatedRunning()) continue;
            ++ret;
        }
        return ret;
    }

    public synchronized Episode getUrlStation(String urlStation) {
        for (Episode episode : this) {
            if (!episode.getEpisodeUrl().equals(urlStation)) continue;
            return episode;
        }
        return null;
    }

    public synchronized List<Episode> getListOfStartsNotFinished(String source2) {
        return this.episodeStartsFactory.getListOfStartsNotFinished(source2);
    }

    public synchronized ObservableList<Podcast> getPodcastList() {
        return this.podcastList;
    }

    private synchronized void genPodcastList() {
        P2Duration.counterStart("genPodcastList");
        P2Log.sysLog("Episoden: genPodcastList");
        LinkedHashSet hashSet = new LinkedHashSet(10);
        ArrayList items = new ArrayList();
        this.stream().forEach(episode -> {
            Podcast podcast = this.progData.podcastList.getPodcastById(episode.getPodcastId());
            if (podcast != null && !hashSet.contains(podcast)) {
                hashSet.add(podcast);
                items.add(podcast);
            }
        });
        Collections.sort(items);
        this.podcastList.setAll(items);
        P2Duration.counterStop("getPodcastList");
    }

    public synchronized ObservableList<String> getGenreList() {
        return this.genreList;
    }

    private synchronized void genGenreList() {
        P2Log.sysLog("Episoden: genGenreList");
        LinkedHashSet hashSet = new LinkedHashSet(10);
        ArrayList items = new ArrayList();
        this.stream().forEach(episode -> {
            String genre = episode.getGenre();
            if (!hashSet.contains(genre)) {
                hashSet.add(genre);
                items.add(genre);
            }
        });
        Collections.sort(items, new GermanStringSorter());
        this.genreList.setAll(items);
    }
}

