/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.data.download;

import java.text.DecimalFormat;

public class DownloadConstants {
    public static final double PROGRESS_NOT_STARTED = -1.0;
    public static final double PROGRESS_WAITING = 0.0;
    public static final double PROGRESS_STARTED = 0.001;
    public static final double PROGRESS_NEARLY_FINISHED = 0.995;
    public static final double PROGRESS_FINISHED = 1.0;
    public static final int STATE_INIT = 0;
    public static final int STATE_STOPPED = 1;
    public static final int STATE_STARTED_WAITING = 2;
    public static final int STATE_STARTED_RUN = 3;
    public static final int STATE_FINISHED = 4;
    public static final int STATE_ERROR = 5;
    private static final DecimalFormat df = new DecimalFormat("###,##0.0");

    public static String getTextProgress(int status, double progress) {
        Object ret = "";
        if (progress == -1.0) {
            ret = status == 1 ? "abgebrochen" : (status == 2 ? "wartet" : (status == 5 ? "fehlerhaft" : "nicht gestartet"));
        } else if (progress == 0.0) {
            ret = "wartet";
        } else if (progress == 0.001) {
            ret = "gestartet";
        } else if (progress > 0.001 && progress < 1.0) {
            ret = df.format(progress * 100.0) + " %";
        } else if (progress == 1.0 && status == 5) {
            ret = "fehlerhaft";
        } else if (progress == 1.0) {
            ret = "fertig";
        }
        return ret;
    }

    public static String getTimeLeft(long timeLeftSeconds) {
        if (timeLeftSeconds > 300L) {
            return Math.round((double)timeLeftSeconds / 60.0) + " Min.";
        }
        if (timeLeftSeconds > 230L) {
            return "5 Min.";
        }
        if (timeLeftSeconds > 170L) {
            return "4 Min.";
        }
        if (timeLeftSeconds > 110L) {
            return "3 Min.";
        }
        if (timeLeftSeconds > 60L) {
            return "2 Min.";
        }
        if (timeLeftSeconds > 30L) {
            return "1 Min.";
        }
        if (timeLeftSeconds > 20L) {
            return "30 s";
        }
        if (timeLeftSeconds > 10L) {
            return "20 s";
        }
        if (timeLeftSeconds > 0L) {
            return "10 s";
        }
        return "";
    }
}

