/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller;

import de.p2tools.p2lib.P2LibInit;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.configfile.ConfigFile;
import de.p2tools.p2lib.configfile.ConfigReadFile;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.log.P2Logger;
import de.p2tools.p2podder.controller.ProgConfigUpdate;
import de.p2tools.p2podder.controller.config.ProgColorList;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.config.ProgInfos;
import de.p2tools.p2podder.controller.config.ProgInfosFactory;
import de.p2tools.p2podder.controller.data.ImportSetDataFactory;
import de.p2tools.p2podder.controller.data.SetDataList;
import de.p2tools.p2podder.gui.startdialog.StartDialogController;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import javafx.application.Platform;

public class ProgStartBeforeGui {
    private ProgStartBeforeGui() {
    }

    public static void workBeforeGui() {
        boolean load = ProgStartBeforeGui.loadAll();
        ProgStartBeforeGui.initP2lib();
        if (!load) {
            P2Duration.onlyPing("Erster Start");
            ProgData.firstProgramStart = true;
            ProgConfigUpdate.setUpdateDone();
            StartDialogController startDialogController = new StartDialogController();
            if (!startDialogController.isOk()) {
                Platform.exit();
                System.exit(0);
            }
        }
        ProgData.getInstance().episodeList.initList();
        ProgData.getInstance().podcastList.initList();
        ProgData.getInstance().downloadList.initList();
        if (ProgData.getInstance().setDataList.isEmpty()) {
            ProgStartBeforeGui.addStandardSets();
        }
    }

    private static void initP2lib() {
        P2LibInit.initLib(ProgData.getInstance().primaryStageBig, "P2Podder", "", ProgConfig.SYSTEM_DARK_THEME, ProgConfig.SYSTEM_BLACK_WHITE_ICON, ProgConfig.SYSTEM_THEME_CHANGED, "de/p2tools/p2podder/podder.css", "de/p2tools/p2podder/podder-dark.css", ProgConfig.SYSTEM_STYLE_SIZE, "", "", ProgData.debug, ProgData.duration);
    }

    private static boolean loadAll() {
        ArrayList<String> logList = new ArrayList<String>();
        boolean ret = ProgStartBeforeGui.load(logList);
        if (ProgConfig.SYSTEM_LOG_ON.getValue().booleanValue()) {
            P2Logger.setFileHandler(ProgInfos.getLogDirectory_String());
        }
        P2Log.sysLog(logList);
        if (!ret) {
            P2Log.sysLog("Weder Konfig noch Backup konnte geladen werden!");
            ProgStartBeforeGui.clearTheConfigs();
        }
        return ret;
    }

    private static boolean load(ArrayList<String> logList) {
        Path xmlFilePath = ProgInfosFactory.getSettingsFile();
        P2Duration.onlyPing("ProgStartFactory.loadProgConfigData");
        try {
            if (!Files.exists(xmlFilePath, new LinkOption[0])) {
                logList.add("Konfig existiert nicht!");
                return false;
            }
            logList.add("Programmstart und ProgConfig laden von: " + String.valueOf(xmlFilePath));
            ConfigFile configFile = new ConfigFile(xmlFilePath.toString(), true){

                @Override
                public void clearConfigFile() {
                    ProgStartBeforeGui.clearTheConfigs();
                }
            };
            ProgConfig.addConfigData(configFile);
            if (ConfigReadFile.readConfig(configFile)) {
                ProgStartBeforeGui.initAfterLoad();
                logList.add("Konfig wurde geladen!");
                return true;
            }
            logList.add("Konfig konnte nicht geladen werden!");
            return false;
        }
        catch (Exception ex) {
            logList.add(ex.getLocalizedMessage());
            return false;
        }
    }

    private static void clearTheConfigs() {
        ProgData progData = ProgData.getInstance();
        progData.setDataList.clear();
        progData.downloadList.clear();
        progData.episodeList.clear();
    }

    private static void addStandardSets() {
        Platform.runLater(() -> {
            P2Duration.onlyPing("Erster Start: PSet");
            try {
                SetDataList pSet = ImportSetDataFactory.getStandarset();
                if (pSet != null) {
                    ProgData.getInstance().setDataList.addSetData(pSet);
                    ProgConfig.SYSTEM_UPDATE_PROGSET_VERSION.setValue(pSet.version);
                }
            }
            catch (Exception ex) {
                P2Log.errorLog(210124589, "Konnte die Sets nicht laden!");
                P2Alert.showErrorAlert(ProgData.getInstance().primaryStage, "Sets einrichten", "Konnte die Sets zum Abspielen der Episoden nicht einrichten");
            }
            P2Duration.onlyPing("Erster Start: PSet geladen");
        });
    }

    private static void initAfterLoad() {
        ProgConfigUpdate.update();
        ProgColorList.setColorTheme();
    }
}

